/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.locator;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.AntVipContext;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.locator.ServerLocator;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.transport.HttpUtil;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store.Store;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.ChecksumUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.math.RandomUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebHostServerLocator
implements ServerLocator {
    private final AntVipContext context;
    private final Store diskStore;
    private volatile List<VipServer> serverList = new ArrayList<VipServer>();
    private volatile String serverListChecksum = "N";
    private volatile Map<String, Integer> serverMap = new HashMap<String, Integer>();
    private final VipServer BASE_VIP_SERVER;
    private static final int MAX_RETRY = 5;
    private volatile int ignoreCnt = 0;
    private static final int MAX_IGNORE = 30;

    public WebHostServerLocator(AntVipContext context, Store diskStore) {
        this.context = context;
        this.diskStore = diskStore;
        this.BASE_VIP_SERVER = new VipServer(context.getConfig().getEndpoint() + ":" + "9500");
        this.aquireVipServers();
        Loggers.STARTUP.info("'serverList' is inited: " + this.serverList);
    }

    private void aquireVipServers() {
        String url = "http://" + this.context.getConfig().getEndpoint() + ":" + "9500" + "/antvip/serversByZone.do";
        if (!this.context.getConfig().isEndpointEnforce()) {
            url = url + "?zone=" + this.context.getConfig().getZone();
        }
        int repeat = 0;
        while (repeat < 5) {
            try {
                ++repeat;
                List<VipServer> vipServers = this.aquireVipServers(url);
                if (null != vipServers && vipServers.size() > 0) {
                    this.serverList = vipServers;
                    this.diskStore.asyncStoreServerListForHttp(this.serverList);
                    break;
                }
                Thread.sleep(5000L);
            }
            catch (Throwable t) {
                Loggers.LOCATOR.error("aquireVipServers failed", t);
            }
        }
        if (this.serverList.size() <= 0) {
            try {
                this.serverList = this.diskStore.loadServerListForHttp();
            }
            catch (IOException e) {
                Loggers.DISK_STORE.info("Loaded local serverList from disk failed");
            }
            Loggers.DISK_STORE.info("Loaded local serverList(%s) from disk", this.serverList);
        }
        if (this.serverList.size() <= 0) {
            this.serverList.add(this.BASE_VIP_SERVER);
        }
    }

    private List<VipServer> aquireVipServers(String webUrl) {
        Loggers.LOCATOR.info("Requesting antvip-servers from:%s", webUrl);
        String res = HttpUtil.httpGet(webUrl);
        if (null != res && !res.isEmpty()) {
            String[] split = StringUtils.split(res.trim(), ",");
            ArrayList<VipServer> vipServerList = new ArrayList<VipServer>();
            for (String ip : split) {
                if (!StringUtils.isNotBlank(ip = ip.trim())) continue;
                vipServerList.add(new VipServer(ip + ":" + "9500"));
            }
            Loggers.LOCATOR.info(">>>>>>>>>>>>>>>>> Receive 'serverList' from WebHost=%s: %s", webUrl, vipServerList);
            return vipServerList;
        }
        Loggers.LOCATOR.error("Request antvip-servers failed from:%s", webUrl);
        return null;
    }

    private List<VipServer> getServerList() {
        if (this.serverList.isEmpty()) {
            this.aquireVipServers();
        }
        return this.serverList;
    }

    @Override
    public VipServer getRandomServer(VipServer ignored) {
        if (null != ignored && null != ignored.getHost()) {
            Integer cnt = this.serverMap.get(ignored.getHost());
            this.serverMap.put(ignored.getHost(), null == cnt ? 1 : 1 + cnt);
            if (this.ignoreCnt++ > 30) {
                this.ignoreCnt = 0;
                this.aquireVipServers();
            }
        }
        List<VipServer> snapshot = this.getServerList();
        ArrayList<VipServer> weightedList = new ArrayList<VipServer>();
        for (VipServer server : snapshot) {
            Integer cnt = this.serverMap.get(server.getHost());
            if (null != cnt && cnt > 1) continue;
            for (int i = 0; i < server.getWeight(); ++i) {
                weightedList.add(server);
            }
        }
        if (weightedList.size() == 0) {
            return this.BASE_VIP_SERVER;
        }
        int index = RandomUtils.nextInt(Short.MAX_VALUE);
        return (VipServer)weightedList.get(index % weightedList.size());
    }

    @Override
    public VipServer getRandomServer() {
        return this.getRandomServer(null);
    }

    @Override
    public String getServerListChecksum() {
        return this.serverListChecksum;
    }

    @Override
    public void resolveVipServers(List<String> vipServerIps) {
        Loggers.LOCATOR.info(">>>>>>>>>>>>>>>>> Receive 'serverList' from antvip: %s", vipServerIps);
        if (null != vipServerIps && !vipServerIps.isEmpty()) {
            this.serverListChecksum = ChecksumUtils.checksum(vipServerIps);
            ArrayList<VipServer> vipServerList = new ArrayList<VipServer>();
            HashMap<String, Integer> vipServerMap = new HashMap<String, Integer>();
            for (String ip : vipServerIps) {
                String host = ip + ":" + "9500";
                vipServerList.add(new VipServer(host));
                vipServerMap.put(host, 0);
            }
            Loggers.LOCATOR.info("resolve vipServers: %s, checksum=%s", vipServerList, this.serverListChecksum);
            this.serverList = vipServerList;
            this.diskStore.asyncStoreServerListForHttp(this.serverList);
            this.serverMap = vipServerMap;
        }
    }

    @Override
    public boolean containsVipServer(VipServer vipServer) {
        if (null != vipServer && null != vipServer.getHost()) {
            return this.serverMap.containsKey(vipServer.getHost());
        }
        Loggers.LOCATOR.warn("vipServer:%s not in current vipServerSet:%s", vipServer, this.serverMap);
        return false;
    }
}

