/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.restrainstrategy;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.restrainstrategy.RestrainStrategy;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.Validate;
import java.util.ArrayList;
import java.util.List;

public class DefaultRestrainStrategy
implements RestrainStrategy {
    private final List<RangeToPercent> rangeToPercents = new ArrayList<RangeToPercent>();

    public DefaultRestrainStrategy(String strategyString) {
        Validate.isTrue(strategyString != null, "'strategyString'is null ");
        String[] splits = StringUtils.split(strategyString, ',');
        Validate.isTrue(splits != null && splits.length > 0, String.format("'strategyString' after split by ',' is empty: %s", strategyString));
        int tempMax = -1;
        for (String split : splits) {
            String[] split2s = StringUtils.split(split, '|');
            Validate.isTrue(split2s != null && split2s.length == 3, String.format("'strategyString'(%s) is invalid", split));
            int min = Integer.parseInt(StringUtils.trim(split2s[0]));
            int max = Integer.parseInt(StringUtils.trim(split2s[1]));
            if (max == -1) {
                max = Integer.MAX_VALUE;
            }
            int percent = Integer.parseInt(StringUtils.trim(split2s[2]));
            Validate.isTrue(min >= 0, String.format("min(%s) is invalid, Must be min>=0 in 'min|max|percent'", min));
            Validate.isTrue(max >= 0, String.format("max(%s) is invalid, Must be max>=0 in 'min|max|percent'", max));
            Validate.isTrue(max >= min, String.format("max(%s) is invalid, Must be max>=min in 'min|max|percent'", max));
            Validate.isTrue(min > tempMax, String.format("min(%s) is invalid, Must be 'min2'>'max1' in 'min1|max1|percent1,min2|max2|percent2'", min));
            Validate.isTrue(percent > 0 && percent <= 100, String.format("percent(%s) is invalid, Must be 0<percent<=100 in 'min|max|percent'", percent));
            tempMax = max;
            RangeToPercent rtp = new RangeToPercent(min, max, percent);
            this.rangeToPercents.add(rtp);
        }
    }

    @Override
    public int getRestrainedSize(int num) {
        if (num <= 0) {
            return num;
        }
        for (RangeToPercent rtp : this.rangeToPercents) {
            if (!rtp.isRange(num)) continue;
            num = num * rtp.percent / 100 + (num * rtp.percent % 100 == 0 ? 0 : 1);
            num = Math.max(num, 1);
            break;
        }
        return num;
    }

    public String toString() {
        return "DefaultRestrainStrategy{rangeToPercents=" + this.rangeToPercents + '}';
    }

    static class RangeToPercent {
        private int min;
        private int max;
        private int percent;

        public RangeToPercent(int min, int max, int percent) {
            this.min = min;
            this.max = max;
            this.percent = percent;
        }

        public boolean isRange(int num) {
            return num >= this.min && num <= this.max;
        }

        public String toString() {
            return "RangeToPercent{min=" + this.min + ", max=" + this.max + ", percent=" + this.percent + '}';
        }
    }
}

