/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.restrainstrategy;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.restrainstrategy.DefaultRestrainStrategy;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.restrainstrategy.RestrainStrategy;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.Validate;
import java.util.HashMap;

public class RestrainStrategyBuilder {
    public static HashMap<String, RestrainStrategy> buildRestrainStrategies(String strategyString) {
        HashMap<String, RestrainStrategy> map = new HashMap<String, RestrainStrategy>();
        if (StringUtils.isBlank(strategyString)) {
            return map;
        }
        String[] splits = StringUtils.split(strategyString, ';');
        Validate.isTrue(splits != null && splits.length > 0, String.format("Invalid strategy string after split by ';' : %s", strategyString));
        for (String split : splits) {
            String[] split2s = StringUtils.split(split, ':');
            Validate.isTrue(split2s != null && split2s.length == 2, String.format("Invalid strategy string: %s", split));
            String appName = StringUtils.trim(split2s[0]);
            String appStrategyString = StringUtils.trim(split2s[1]);
            Validate.isTrue(StringUtils.isNotEmpty(appName), String.format("appName cannot be empty: %s", split));
            Validate.isTrue(StringUtils.isNotEmpty(appStrategyString), String.format("appStrategyString cannot be empty: %s", split));
            DefaultRestrainStrategy strategy = new DefaultRestrainStrategy(appStrategyString);
            map.put(appName, strategy);
        }
        return map;
    }
}

