/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.statistics;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ApiStatistics {
    private ConcurrentHashMap<String, AtomicLong> successQuery = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> notExistQuery = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> failQuery = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> degradeQuery = new ConcurrentHashMap();
    private static final int MAX_CNT = 16384;
    private boolean notExistQueryExceed;
    private boolean failQueryExceed;
    private AtomicLong discardDnsCnt = new AtomicLong();

    public void statDiscardDns() {
        this.discardDnsCnt.incrementAndGet();
    }

    public void statNotExist(String domain) {
        if (!this.notExistQueryExceed) {
            this.stat(this.notExistQuery, domain);
            this.notExistQueryExceed = this.notExistQuery.size() > 16384;
        }
    }

    public void statSuccess(String domain) {
        if (!this.failQueryExceed) {
            this.stat(this.successQuery, domain);
            this.failQueryExceed = this.failQuery.size() > 16384;
        }
    }

    public void statFail(String domain) {
        this.stat(this.failQuery, domain);
    }

    public void statDegrade(String domain) {
        this.stat(this.degradeQuery, domain);
    }

    private void stat(ConcurrentHashMap<String, AtomicLong> map, String domain) {
        AtomicLong previous;
        AtomicLong count = map.get(domain);
        if (count == null && (previous = map.putIfAbsent(domain, count = new AtomicLong(0L))) != null) {
            count = previous;
        }
        count.incrementAndGet();
    }

    public void printStatInfo() {
        StatEntry statEntry;
        AtomicLong count;
        String domain;
        long domainCount = 0L;
        long queryCount = 0L;
        HashMap<String, StatEntry> map = new HashMap<String, StatEntry>();
        for (Map.Entry<String, AtomicLong> entry : this.successQuery.entrySet()) {
            domain = entry.getKey();
            count = entry.getValue();
            statEntry = (StatEntry)map.get(domain);
            if (statEntry == null) {
                statEntry = new StatEntry();
                map.put(domain, statEntry);
            }
            statEntry.successCount = count.longValue();
            queryCount += statEntry.successCount;
        }
        for (Map.Entry<String, AtomicLong> entry : this.notExistQuery.entrySet()) {
            domain = entry.getKey();
            count = entry.getValue();
            statEntry = (StatEntry)map.get(domain);
            if (statEntry == null) {
                statEntry = new StatEntry();
                map.put(domain, statEntry);
            }
            statEntry.notExistCount = count.longValue();
            queryCount += statEntry.notExistCount;
        }
        for (Map.Entry<String, AtomicLong> entry : this.failQuery.entrySet()) {
            domain = entry.getKey();
            count = entry.getValue();
            statEntry = (StatEntry)map.get(domain);
            if (statEntry == null) {
                statEntry = new StatEntry();
                map.put(domain, statEntry);
            }
            statEntry.failCount = count.longValue();
            queryCount += statEntry.failCount;
        }
        for (Map.Entry<String, AtomicLong> entry : this.degradeQuery.entrySet()) {
            domain = entry.getKey();
            count = entry.getValue();
            statEntry = (StatEntry)map.get(domain);
            if (statEntry == null) {
                statEntry = new StatEntry();
                map.put(domain, statEntry);
            }
            statEntry.degradeCount = count.longValue();
            queryCount += statEntry.degradeCount;
        }
        domainCount = map.size();
        Loggers.API_STATISTICS.info("[summary] totalQueryDomains:%s, totalQueryCount:%s", domainCount, queryCount);
        StringBuilder statStr = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            statStr.append((String)entry.getKey()).append(':');
            statStr.append(((StatEntry)entry.getValue()).successCount).append(',');
            statStr.append(((StatEntry)entry.getValue()).notExistCount).append(',');
            statStr.append(((StatEntry)entry.getValue()).failCount).append(',');
            statStr.append(((StatEntry)entry.getValue()).degradeCount).append(';');
        }
        Loggers.API_STATISTICS.info("[detail] %s", statStr);
        if (this.discardDnsCnt.get() > 0L) {
            Loggers.API_STATISTICS.info("[discardDnsCnt] %s", this.discardDnsCnt.get());
        }
    }

    public void printAndClearStatInfo() {
        this.printStatInfo();
        this.successQuery = new ConcurrentHashMap();
        this.notExistQuery = new ConcurrentHashMap();
        this.failQuery = new ConcurrentHashMap();
        this.degradeQuery = new ConcurrentHashMap();
        this.notExistQueryExceed = false;
        this.failQueryExceed = false;
        this.discardDnsCnt = new AtomicLong();
    }

    private static class StatEntry {
        long successCount;
        long notExistCount;
        long failCount;
        long degradeCount;

        private StatEntry() {
        }
    }
}

