/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.store;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.fastjson.AntVipPropertyFilter;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.log.DiskStoreLogger;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.RealNode;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store.DiskStore;
import java.io.IOException;

public class ClientDiskStore
extends DiskStore {
    private static final int MAX_REAL_NODE_LOG_COUNT = 100;
    private static final AntVipPropertyFilter[] FILTERS;

    public ClientDiskStore(String diskStoreDir) {
        super(diskStoreDir, FILTERS);
    }

    @Override
    public void storeVipDomain(VipDomain vipDomain) throws IOException {
        super.storeVipDomain(vipDomain);
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("Store vipDomain: %s, version=%s. RealServers count=%s:(first %s)[", vipDomain.getName(), vipDomain.getVersion(), vipDomain.getRealNodes().size(), 100));
        int printCount = Math.min(vipDomain.getRealNodes().size(), 100);
        for (int i = 0; i < printCount; ++i) {
            RealNode realNode = vipDomain.getRealNodes().get(i);
            sb.append(realNode.getIp()).append("=").append(realNode.getAvailable()).append(",");
        }
        sb.append("]");
        DiskStoreLogger.getInstance().info(sb.toString());
    }

    static {
        AntVipPropertyFilter REALNODE_FILTER = new AntVipPropertyFilter(RealNode.class, new String[0]);
        AntVipPropertyFilter VIPDOMAIN_FILTER = new AntVipPropertyFilter(VipDomain.class, new String[0]);
        REALNODE_FILTER.getIncludes().add("ip");
        REALNODE_FILTER.getIncludes().add("weight");
        REALNODE_FILTER.getIncludes().add("healthCheckPort");
        REALNODE_FILTER.getIncludes().add("available");
        REALNODE_FILTER.getIncludes().add("zone");
        REALNODE_FILTER.getIncludes().add("rnLabels");
        VIPDOMAIN_FILTER.getIncludes().add("name");
        VIPDOMAIN_FILTER.getIncludes().add("healthCheckDefaultPort");
        VIPDOMAIN_FILTER.getIncludes().add("protectThreshold");
        VIPDOMAIN_FILTER.getIncludes().add("idcDisasterProtect");
        VIPDOMAIN_FILTER.getIncludes().add("realNodes");
        VIPDOMAIN_FILTER.getIncludes().add("version");
        VIPDOMAIN_FILTER.getIncludes().add("domainLabels");
        FILTERS = new AntVipPropertyFilter[]{VIPDOMAIN_FILTER, REALNODE_FILTER};
    }
}

