/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.transport;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingRequest;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;

public class HttpUtil {
    private static int HTTP_CONNECTION_TIMEOUT = 2500;
    private static int HTTP_READ_TIMEOUT = 3000;
    private static int POLLING_CONNECTION_TIMEOUT = 10000;
    private static int POLLING_READ_TIMEOUT = 100000;

    public static String httpGet(String urlString) {
        if (urlString == null || !urlString.toLowerCase().startsWith("http://")) {
            return null;
        }
        Loggers.SYNC_SERVER.info(HttpUtil.class, "Sending http request to (%s)", urlString);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            URL url = new URL(urlString);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setConnectTimeout(HTTP_CONNECTION_TIMEOUT);
            httpConnection.setReadTimeout(HTTP_READ_TIMEOUT);
            httpConnection.setRequestMethod("GET");
            httpConnection.setDoOutput(false);
            httpConnection.setDoInput(true);
            httpConnection.connect();
            if (200 == httpConnection.getResponseCode()) {
                String strCurrentLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
                while ((strCurrentLine = reader.readLine()) != null) {
                    stringBuffer.append(strCurrentLine).append("\n");
                }
                reader.close();
            }
        }
        catch (Throwable e) {
            Loggers.SYNC_SERVER.error(HttpUtil.class, e, "Send http request to (%s) failed", urlString);
        }
        Loggers.SYNC_SERVER.info(HttpUtil.class, "Receive http response from (%s), response=%s", urlString, stringBuffer.toString());
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String queryDomain(String urlString, PollingRequest request) throws IOException {
        int code;
        HttpURLConnection httpConnection;
        if (urlString == null) return null;
        if (!urlString.toLowerCase().startsWith("http://")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FilterOutputStream out = null;
        try {
            URL url = new URL(urlString);
            httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setConnectTimeout(POLLING_CONNECTION_TIMEOUT);
            httpConnection.setReadTimeout(POLLING_READ_TIMEOUT);
            httpConnection.setRequestMethod("POST");
            httpConnection.setDoOutput(true);
            httpConnection.setDoInput(true);
            String reqJson = JSON.toJSONString(request);
            out = new DataOutputStream(httpConnection.getOutputStream());
            ((DataOutputStream)out).writeBytes(reqJson);
            ((DataOutputStream)out).flush();
            code = httpConnection.getResponseCode();
        }
        catch (Exception e) {
            Loggers.SYNC_SERVER.error(HttpUtil.class, e, "Send http request to (%s) failed, local_ip(%s)", urlString, InetAddress.getLocalHost().getHostAddress());
            throw new IOException(String.format("HttpReqeust (%s) failed, %s", urlString, e.getMessage()));
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
        if (code != 200) return stringBuffer.toString();
        BufferedReader reader = null;
        try {
            String strCurrentLine;
            reader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
            while ((strCurrentLine = reader.readLine()) != null) {
                stringBuffer.append(strCurrentLine).append("\n");
            }
            if (reader == null) return stringBuffer.toString();
        }
        catch (IOException e) {
            try {
                Loggers.SYNC_SERVER.error(HttpUtil.class, e, "Send http request to (%s) failed, local_ip_(%s)", urlString, InetAddress.getLocalHost().getHostAddress());
                throw new IOException(String.format("Read from response failed, %s", urlString, e.getMessage()));
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Loggers.SYNC_SERVER.error(HttpUtil.class, e2, "Close reader failed", new Object[0]);
                    throw new IOException(String.format("Close reader failed", urlString, e2.getMessage()));
                }
            }
        }
        try {
            reader.close();
            return stringBuffer.toString();
        }
        catch (IOException e) {
            Loggers.SYNC_SERVER.error(HttpUtil.class, e, "Close reader failed", new Object[0]);
            throw new IOException(String.format("Close reader failed", urlString, e.getMessage()));
        }
    }
}

