/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.transport;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSONObject;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.DefaultAntVipClient;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.ExtensionParamsCache;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.AntVipContext;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.AntvipClientType;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.NoAvailableServerException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.VipDomainWithWeight;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.locator.ServerLocator;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.transport.AbstractSynchronizer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.transport.HttpUtil;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.island.IslandListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipIOException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipResponseException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.DomainNotFoundException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.listener.VipDomainDeleteListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.listener.VipDomainListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.listener.VipDomainNameListListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store.Store;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.thread.AntVipUncaughtExceptionHandler;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.thread.ThreadFactoryBuilder;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingRequest;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingResponse;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.AntVipUtils;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.ChecksumUtils;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.CompatibleChecksumUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class VipServerSynchronizer
extends AbstractSynchronizer {
    private final ThreadPoolExecutor islandListenerExecutor;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ServerLocator vipServerLocator;
    private final ExtensionParamsCache extensionParamsCache;
    private final List<VipDomainNameListListener> nameListListeners = new ArrayList<VipDomainNameListListener>();
    private final List<VipDomainListener> vipDomainListeners = new ArrayList<VipDomainListener>();
    private final List<VipDomainDeleteListener> vipDomainDeleteListeners = new ArrayList<VipDomainDeleteListener>();
    private final AntVipContext context;
    private volatile boolean island = false;
    private volatile boolean islandCity = false;
    private List<IslandListener> islandListeners = new ArrayList<IslandListener>();
    private boolean loggedNoAvailableServerExceptionSign = false;
    private Store diskStore;
    private VipServer curVipServer;

    public VipServerSynchronizer(AntVipContext context, ServerLocator vipServerLocator, ExtensionParamsCache extensionParamsCache, Store diskStore) {
        this.context = context;
        this.vipServerLocator = vipServerLocator;
        this.extensionParamsCache = extensionParamsCache;
        this.diskStore = diskStore;
        Loggers.DISK_STORE.info(null == diskStore ? "disk_store:null" : diskStore.toString());
        this.curVipServer = vipServerLocator.getRandomServer();
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        threadFactoryBuilder.setUncaughtExceptionHandler(AntVipUncaughtExceptionHandler.INSTANCE);
        this.islandListenerExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactoryBuilder.setNameFormat("AntVip-IslandListenerExecutor").build());
        this.islandListenerExecutor.allowCoreThreadTimeOut(true);
    }

    @Override
    public void start() {
        this.scheduleSendRequest(0L, TimeUnit.MILLISECONDS);
        Loggers.STARTUP.info(VipServerSynchronizer.class, "Started.");
    }

    @Override
    public void close() {
        super.close();
        this.closed.compareAndSet(false, true);
        Loggers.STARTUP.info(VipServerSynchronizer.class, "Close.");
    }

    @Override
    public List<String> getVipDomainNameList(long timeout) throws AntVipIOException {
        if (this.context.getConfig().getDrmSyncControl().isDisableSync()) {
            Loggers.SYNC_SERVER.warn("Remote sync is disabled, so return empty nameList");
            return Collections.emptyList();
        }
        try {
            Loggers.SYNC_SERVER.info("One-time request for domainNameList from VipServer(%s)", this.curVipServer.getHost());
            PollingRequest request = new PollingRequest();
            request.setFrom(this.context.getConfig().getTrFrom());
            request.setClientVersion(this.context.getConfig().getVersion());
            request.setAllowPolling(false);
            request.setNameListChecksum("N");
            request.setStartTime(System.currentTimeMillis());
            HashMap<String, Object> extParams = new HashMap<String, Object>();
            extParams.put("appName", this.context.getConfig().getAppName());
            extParams.put("traceId", UUID.randomUUID().toString());
            request.setExtensionParams(extParams);
            String responseJson = HttpUtil.queryDomain(this.getHttpUrl(), request);
            PollingResponse response = JSONObject.parseObject(responseJson, PollingResponse.class);
            if (null == response) {
                throw new AntVipResponseException("PollingResponse is null");
            }
            response.checkSuccess();
            Loggers.SYNC_SERVER.logOneTimeSyncNameList(this.curVipServer, request, response);
            List<String> nameList = response.getNameList();
            if (nameList != null) {
                return nameList;
            }
            return Collections.emptyList();
        }
        catch (Throwable e) {
            throw new AntVipIOException("Error when fetching domainNameList from server", e);
        }
    }

    @Override
    public VipDomain getVipDomain(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        ArrayList<String> domainNames = new ArrayList<String>(1);
        domainNames.add(domainName);
        List<VipDomain> list = this.getVipDomains(domainNames, timeoutMs);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        throw new DomainNotFoundException(domainName, "Server return no domain data");
    }

    @Override
    public List<VipDomain> getVipDomains(Collection<String> domainNames, long timeout) throws AntVipIOException, DomainNotFoundException {
        if (this.context.getConfig().getDrmSyncControl().isDisableSync()) {
            throw new AntVipIOException("Remote sync is disabled");
        }
        if (domainNames.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Loggers.SYNC_SERVER.info("One-time request for domains(%s) from VipServer(%s)", domainNames.toString(), this.curVipServer.getHost());
            PollingRequest request = new PollingRequest();
            request.setFrom(this.context.getConfig().getTrFrom());
            request.setClientVersion(this.context.getConfig().getVersion());
            request.setAllowPolling(false);
            HashMap<String, String> vipDomainName2ChecksumMap = new HashMap<String, String>();
            for (String domainName : domainNames) {
                vipDomainName2ChecksumMap.put(domainName, "N");
            }
            request.setVipDomainName2ChecksumMap(vipDomainName2ChecksumMap);
            request.setRequestTimeLimitMS(timeout);
            request.setStartTime(System.currentTimeMillis());
            HashMap<String, Object> extParams = new HashMap<String, Object>();
            extParams.put("appName", this.context.getConfig().getAppName());
            extParams.put("traceId", UUID.randomUUID().toString());
            request.setExtensionParams(extParams);
            String responseJson = HttpUtil.queryDomain(this.getHttpUrl(), request);
            PollingResponse response = JSONObject.parseObject(responseJson, PollingResponse.class);
            if (null == response) {
                throw new AntVipResponseException("PollingResponse is null");
            }
            response.checkSuccess();
            Loggers.SYNC_SERVER.logOneTimeSyncVipDomains(this.curVipServer, request, response);
            List<VipDomain> list = response.getVipDomains();
            if (list == null) {
                list = Collections.emptyList();
            }
            for (VipDomain vipDomain : list) {
                AntVipUtils.resolveVipDomain(vipDomain);
            }
            return list;
        }
        catch (Throwable e) {
            throw new AntVipIOException(String.format("Error when fetching multiple domains(%s) from server", domainNames.toString()), e);
        }
    }

    public void registerIslandListener(IslandListener listener) {
        this.islandListeners.add(listener);
    }

    private void scheduleSendRequest(long delay, TimeUnit timeUnit) {
        if (!this.closed.get()) {
            try {
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (!VipServerSynchronizer.this.context.getConfig().getDrmControl().isMainSwitch() || VipServerSynchronizer.this.context.getConfig().getDrmSyncControl().isDisableSync()) {
                            VipServerSynchronizer.this.scheduleSendRequest(VipServerSynchronizer.this.context.getConfig().getDrmSyncControl().getDisableSyncCheckIntervalSeconds(), TimeUnit.SECONDS);
                            return;
                        }
                        try {
                            PollingRequest request = VipServerSynchronizer.this.buildRequest();
                            Loggers.SYNC_SERVER.info("Syncing from VipServer(%s)", VipServerSynchronizer.this.curVipServer.getHost());
                            String responseJson = HttpUtil.queryDomain(VipServerSynchronizer.this.getHttpUrl(), request);
                            PollingResponse response = JSONObject.parseObject(responseJson, PollingResponse.class);
                            Loggers.SYNC_SERVER.logSync(VipServerSynchronizer.this.curVipServer, request, response);
                            VipServerSynchronizer.this.handleResponse(response);
                        }
                        catch (Throwable e) {
                            VipServerSynchronizer.this.onThrowable(e);
                        }
                    }
                }, delay, timeUnit);
            }
            catch (Throwable t) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Loggers.SYNC_SERVER.error(e, "InterruptedException", new Object[0]);
                }
                this.onThrowable(t);
            }
        }
    }

    private String getHttpUrl() {
        String targetIp = StringUtils.contains(this.curVipServer.getHost(), ":") ? StringUtils.substringBefore(this.curVipServer.getHost(), ":") : this.curVipServer.getHost();
        return "http://" + targetIp + ":9500" + "/antvipDomains";
    }

    public void handleResponse(Object appResponse) {
        PollingResponse response = (PollingResponse)appResponse;
        try {
            if (null == response) {
                throw new AntVipResponseException("PollingResponse is null");
            }
            response.checkSuccess();
            this.deelResponse((PollingResponse)appResponse);
            this.scheduleSendRequest(this.context.getConfig().getDrmSyncControl().getSuccessParkIntervalMs(), TimeUnit.MILLISECONDS);
        }
        catch (AntVipResponseException e) {
            this.onThrowable(e);
        }
        catch (Throwable e) {
            this.onThrowable(e);
        }
    }

    private void deelResponse(PollingResponse vipResponse) {
        List<VipDomain> vipDomains;
        AntVipUtils.resolvePollingResponse(vipResponse);
        this.processExtensionParams(vipResponse.getExtensionParams());
        List<String> vipDomainNameList = vipResponse.getNameList();
        if (vipDomainNameList != null && !vipDomainNameList.isEmpty()) {
            Loggers.SYNC_SERVER.info(">>>>>>>>>>>>>>>>> (from VipServer(%s)) 'nameList' changed, list size is %s", this.curVipServer.getHost(), vipDomainNameList.size());
            for (VipDomainNameListListener listener : this.nameListListeners) {
                listener.onNameListChanged(vipDomainNameList);
            }
        }
        if ((vipDomains = vipResponse.getVipDomains()) != null) {
            Loggers.SYNC_SERVER.logChangedVipDomains(vipDomains, 100, this.curVipServer.getHost());
            for (VipDomainListener vipDomainListener : this.vipDomainListeners) {
                vipDomainListener.onVipDomainChanged(vipDomains);
            }
        }
    }

    private static List<String> getListValue(Object source) {
        if (null == source) {
            return null;
        }
        if (source instanceof String) {
            String[] split = StringUtils.split((String)source, ",");
            return Arrays.asList(split);
        }
        if (source instanceof List) {
            return (List)source;
        }
        return null;
    }

    private void processExtensionParams(Map<String, Object> extensionParams) {
        if (null == extensionParams) {
            return;
        }
        try {
            List<String> list;
            if (!this.context.getConfig().isPollingNameList() && null != extensionParams.get("EXTENSION_NOT_EXIST_DOMAINS")) {
                List<String> deletedDomains = VipServerSynchronizer.getListValue(extensionParams.get("EXTENSION_NOT_EXIST_DOMAINS"));
                Loggers.SYNC_SERVER.logDeletedVipDomains(deletedDomains, this.curVipServer.getHost());
                for (VipDomainDeleteListener vipDomainDeleteListener : this.vipDomainDeleteListeners) {
                    vipDomainDeleteListener.onVipDomainDelete(deletedDomains);
                }
            }
            if (null != extensionParams.get("EXTENSION_SERVER_LIST")) {
                List<String> vipServers = VipServerSynchronizer.getListValue(extensionParams.get("EXTENSION_SERVER_LIST"));
                this.vipServerLocator.resolveVipServers(vipServers);
            }
            this.processIsland(extensionParams);
            if (null != extensionParams.get("EXTENSION_ZONE_INFO_LIST")) {
                List<String> zoneInfoList = VipServerSynchronizer.getListValue(extensionParams.get("EXTENSION_ZONE_INFO_LIST"));
                this.extensionParamsCache.resolveZoneInfo(zoneInfoList);
                for (Map.Entry entry : this.context.getResolvedVipDomains().entrySet()) {
                    VipDomainWithWeight vipDomainWithWeight = (VipDomainWithWeight)entry.getValue();
                    if (null == vipDomainWithWeight) continue;
                    vipDomainWithWeight.refreshLocalRsMap();
                }
            }
            if (null != extensionParams.get("EXTENSION_DNSFILTER_WHITE_LIST") && null != (list = VipServerSynchronizer.getListValue(extensionParams.get("EXTENSION_DNSFILTER_WHITE_LIST")))) {
                this.extensionParamsCache.resolveWhiteList(list);
            }
            if (null != extensionParams.get("EXTENSION_DNSFILTER_BLACK_LIST") && null != (list = VipServerSynchronizer.getListValue(extensionParams.get("EXTENSION_DNSFILTER_BLACK_LIST")))) {
                this.extensionParamsCache.resolveBlackList(list);
            }
            if (null != extensionParams.get("EXTENSION_DIVISION_BY_ENV0_DOMAINS") && null != (list = VipServerSynchronizer.getListValue(extensionParams.get("EXTENSION_DIVISION_BY_ENV0_DOMAINS")))) {
                this.extensionParamsCache.resolveDivisionByEnv0Domains(list);
            }
        }
        catch (Throwable t) {
            Loggers.SYNC_SERVER.error("processExtensionParams error", t);
        }
    }

    private void processIsland(Map<String, Object> extensionParams) {
        Boolean extensionCityIsland;
        if (this.closed.get()) {
            return;
        }
        Boolean extensionIsland = (Boolean)extensionParams.get("EXTENSION_ISLAND");
        if (null != extensionIsland) {
            boolean serverIsland = extensionIsland;
            if (serverIsland && !this.island) {
                this.islandListenerExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (IslandListener listener : VipServerSynchronizer.this.islandListeners) {
                            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                                Loggers.CLIENT_LISTENER.info("Trigger IslandListener(class:%s) onIsland()", listener.getClass());
                                listener.onIsland();
                            }
                            catch (Throwable e) {
                                Loggers.CLIENT_LISTENER.error(e, "Error on IslandListener(class:%s)", listener.getClass());
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(tcl);
                            }
                        }
                    }
                });
            } else if (!serverIsland && this.island) {
                this.islandListenerExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (IslandListener listener : VipServerSynchronizer.this.islandListeners) {
                            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                                Loggers.CLIENT_LISTENER.info("Trigger IslandListener(class:%s) outIsland()", listener.getClass());
                                listener.outIsland();
                            }
                            catch (Throwable e) {
                                Loggers.CLIENT_LISTENER.error(e, "Error on IslandListener(class:%s)", listener.getClass());
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(tcl);
                            }
                        }
                    }
                });
            }
            Loggers.CLIENT_LISTENER.warn("Island status changed from [%s] to [%s]", this.island, serverIsland);
            this.island = serverIsland;
        }
        if (null != (extensionCityIsland = (Boolean)extensionParams.get("EXTENSION_CITY_ISLAND"))) {
            boolean serverCityIsland = extensionCityIsland;
            if (serverCityIsland && !this.islandCity) {
                this.islandListenerExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (IslandListener listener : VipServerSynchronizer.this.islandListeners) {
                            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                                Loggers.CLIENT_LISTENER.info("Trigger IslandListener(class:%s) onCityIsland()", listener.getClass());
                                listener.onCityIsland();
                            }
                            catch (Throwable e) {
                                Loggers.CLIENT_LISTENER.error(e, "Error on IslandListener(class:%s)", listener.getClass());
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(tcl);
                            }
                        }
                    }
                });
            } else if (!serverCityIsland && this.islandCity) {
                this.islandListenerExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (IslandListener listener : VipServerSynchronizer.this.islandListeners) {
                            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                                Loggers.CLIENT_LISTENER.info("Trigger IslandListener(class:%s) outCityIsland()", listener.getClass());
                                listener.outCityIsland();
                            }
                            catch (Throwable e) {
                                Loggers.CLIENT_LISTENER.error(e, "Error on IslandListener(class:%s)", listener.getClass());
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(tcl);
                            }
                        }
                    }
                });
            }
            Loggers.CLIENT_LISTENER.warn("CityIsland status changed from [%s] to [%s]", this.islandCity, serverCityIsland);
            this.islandCity = serverCityIsland;
        }
    }

    private PollingRequest buildRequest() {
        PollingRequest request = new PollingRequest();
        request.setFrom(this.context.getConfig().getTrFrom());
        request.setClientVersion(this.context.getConfig().getVersion());
        HashMap<String, Object> extParams = new HashMap<String, Object>();
        extParams.put("appName", this.context.getConfig().getAppName());
        extParams.put("checksumForCompatibleSign", true);
        extParams.put("traceId", UUID.randomUUID().toString());
        if (StringUtils.isNotBlank(this.context.getConfig().getZone())) {
            extParams.put("EXTENSION_ZONE", this.context.getConfig().getZone());
        }
        extParams.put("EXTENSION_SERVER_LIST", this.vipServerLocator.getServerListChecksum());
        if (AntvipClientType.JAVA_CLIENT.equals((Object)this.context.getConfig().getAntvipClientType())) {
            extParams.put("EXTENSION_ISLAND", this.island);
            extParams.put("EXTENSION_CITY_ISLAND", this.islandCity);
            extParams.put("EXTENSION_ZONE_INFO_LIST", this.extensionParamsCache.getZoneInfoListChecksum());
        } else if (AntvipClientType.ANT_DNS_FILTER.equals((Object)this.context.getConfig().getAntvipClientType())) {
            extParams.put("EXTENSION_DNSFILTER_WHITE_LIST", this.extensionParamsCache.getDnsfilterWhiteListChecksum());
            extParams.put("EXTENSION_DNSFILTER_BLACK_LIST", this.extensionParamsCache.getDnsfilterBlackListChecksum());
            extParams.put("EXTENSION_DIVISION_BY_ENV0_DOMAINS", this.extensionParamsCache.getDivisionByEnv0DomainsChecksum());
        }
        request.setExtensionParams(extParams);
        HashMap<String, String> vipDomainName2ChecksumMap = new HashMap<String, String>();
        if (!this.context.getResolvedVipDomains().isEmpty()) {
            Iterator<Map.Entry<String, VipDomainWithWeight>> iterator = this.context.getResolvedVipDomains().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, VipDomainWithWeight> entry = iterator.next();
                String vipDomainName = entry.getKey();
                VipDomainWithWeight vipDomainWithWeight = entry.getValue();
                if (AntvipClientType.ANT_DNS_FILTER.equals((Object)this.context.getConfig().getAntvipClientType()) && vipDomainWithWeight.expired()) {
                    iterator.remove();
                    Loggers.CACHE.info(DefaultAntVipClient.class, "[resolvedVipDomains] remove domain=%s, for vipDomain expired", vipDomainName);
                    this.diskStore.asyncDeleteVipDomain(vipDomainName);
                    continue;
                }
                vipDomainName2ChecksumMap.put(vipDomainName, CompatibleChecksumUtils.checksumForClientCompatible(vipDomainWithWeight.getVipDomain()));
            }
        }
        if (this.context.getConfig().isPollingNameList()) {
            request.setNameListChecksum(ChecksumUtils.checksum(this.context.getNameListHolder().getNameList()));
        } else if (!this.context.getNotExistDomains().isEmpty()) {
            long current = System.currentTimeMillis();
            Iterator iterator = this.context.getNotExistDomains().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (this.context.getResolvedVipDomains().containsKey(entry.getKey()) || AntvipClientType.ANT_DNS_FILTER.equals((Object)this.context.getConfig().getAntvipClientType()) && current - (Long)entry.getValue() > this.context.getConfig().getDrmSyncControl().getNotExistExpireTimeMs()) {
                    iterator.remove();
                    Loggers.CACHE.info(DefaultAntVipClient.class, "[NotExistDomains] remove domain=%s, for no exist polling timeout", entry.getKey());
                    continue;
                }
                vipDomainName2ChecksumMap.put((String)entry.getKey(), "N");
            }
        }
        request.setVipDomainName2ChecksumMap(vipDomainName2ChecksumMap);
        request.setStartTime(System.currentTimeMillis());
        return request;
    }

    private void onThrowable(Throwable e) {
        long delay = 5L;
        try {
            if (e instanceof NoAvailableServerException) {
                delay = this.context.getConfig().getDrmSyncControl().getNoAvailableServerCheckIntervalSeconds();
                if (!this.loggedNoAvailableServerExceptionSign) {
                    Loggers.SYNC_SERVER.error(e, "Error(%s) when sync from VipServer, will be retry every %ssec quietly, until there are available servers.", e.getClass().getName(), delay);
                    this.loggedNoAvailableServerExceptionSign = true;
                }
                this.scheduleSendRequest(delay, TimeUnit.SECONDS);
                return;
            }
            delay = e instanceof AntVipResponseException ? this.context.getConfig().getDrmSyncControl().getResponseExceptionIntervalSeconds() : this.context.getConfig().getDrmSyncControl().getUnknownErrorIntervalSeconds();
            Loggers.SYNC_SERVER.error(e, "Error(%s) when sync from VipServer, try in %ssec.", e.getClass().getName(), delay);
        }
        catch (Throwable t) {
            Loggers.SYNC_SERVER.error(e, "Error(%s) when sync from VipServer onThrowable, try in %ssec.", e.getClass().getName(), delay);
        }
        this.curVipServer = this.vipServerLocator.getRandomServer(this.curVipServer);
        this.scheduleSendRequest(delay, TimeUnit.SECONDS);
    }

    @Override
    public void addVipDomainListener(VipDomainListener listener) {
        this.vipDomainListeners.add(listener);
    }

    @Override
    public void addVipDomainNameListListener(VipDomainNameListListener listener) {
        this.nameListListeners.add(listener);
    }

    @Override
    public void addVipDomainDeleteListener(VipDomainDeleteListener listener) {
        this.vipDomainDeleteListeners.add(listener);
    }

    public boolean isIsland() {
        return this.island;
    }

    public boolean isIslandCity() {
        return this.islandCity;
    }
}

