/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.util;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ZoneUtil {
    public static String getZone(String[] envs) {
        if (null != envs) {
            for (String env : envs) {
                if (StringUtils.startsWithIgnoreCase(env, "ALIPAY_ZONE=")) {
                    return StringUtils.substringAfter(env, "ALIPAY_ZONE=");
                }
                if (StringUtils.startsWithIgnoreCase(env, "ALIPAY_APP_ZONE=")) {
                    return StringUtils.substringAfter(env, "ALIPAY_APP_ZONE=");
                }
                if (!StringUtils.startsWithIgnoreCase(env, "ZONE=")) continue;
                return StringUtils.substringAfter(env, "ZONE=");
            }
        }
        return "";
    }

    public static String getZoneFromEnv() {
        Map<String, String> envMap = System.getenv();
        Loggers.STARTUP.info("env: %s", envMap);
        if (null != envMap) {
            if (StringUtils.isNotBlank(envMap.get("ALIPAY_ZONE"))) {
                return envMap.get("ALIPAY_ZONE");
            }
            if (StringUtils.isNotBlank(envMap.get("ALIPAY_APP_ZONE"))) {
                return envMap.get("ALIPAY_APP_ZONE");
            }
            if (StringUtils.isNotBlank(envMap.get("ZONE"))) {
                return envMap.get("ZONE");
            }
        }
        return null;
    }

    public static String getZoneFromFile(String file) {
        try {
            FileInputStream in = new FileInputStream(file);
            if (null != in) {
                Properties props = new Properties();
                props.load(in);
                ((InputStream)in).close();
                return props.getProperty("zone");
            }
        }
        catch (FileNotFoundException e) {
            Loggers.STARTUP.error(e.getMessage(), e);
        }
        catch (IOException e) {
            Loggers.STARTUP.error(e.getMessage(), e);
        }
        return null;
    }
}

