/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.executor;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.executor.RunnableWithKey;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class OrderedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final RunnableNode end = new RunnableNode(null);
    private final AtomicReferenceFieldUpdater<RunnableNode, RunnableNode> fieldUpdater = AtomicReferenceFieldUpdater.newUpdater(RunnableNode.class, RunnableNode.class, "next");
    protected final ConcurrentMap<Object, RunnableNode> map = this.newMap();

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    protected ConcurrentMap<Object, RunnableNode> newMap() {
        return new ConcurrentHashMap<Object, RunnableNode>();
    }

    @Override
    public void execute(Runnable task) {
        if (task instanceof RunnableWithKey) {
            RunnableWithKey taskWithKey = (RunnableWithKey)task;
            RunnableNode newNode = new RunnableNode(taskWithKey);
            Object key = taskWithKey.key();
            RunnableNode previousEventTask = this.map.put(key, newNode);
            if (previousEventTask != null && this.compareAndSetNext(previousEventTask, null, newNode)) {
                return;
            }
            super.execute(newNode);
        } else {
            super.execute(task);
        }
    }

    protected boolean removeKey(Object key) {
        return this.map.remove(key) != null;
    }

    protected final boolean compareAndSetNext(RunnableNode node, RunnableNode expect, RunnableNode update) {
        return this.fieldUpdater.compareAndSet(node, expect, update);
    }

    @Override
    public void shutdown() {
        this.map.clear();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.map.clear();
        return super.shutdownNow();
    }

    protected final class RunnableNode
    implements Runnable {
        volatile RunnableNode next;
        private final Runnable runnable;

        RunnableNode(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                if (!OrderedThreadPoolExecutor.this.compareAndSetNext(this, null, OrderedThreadPoolExecutor.this.end)) {
                    OrderedThreadPoolExecutor.super.execute(this.next);
                }
            }
        }
    }
}

