/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.hash;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.hash.IHashModel;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.hash.ServerLocator;
import com.alipay.sofa.sofamq.org.shade.apache.commons.codec.digest.DigestUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.Validate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConHashServerLocator
implements ServerLocator {
    private static final int REPETITION_MULTIPLE = 120;
    private volatile TreeMap<Long, IHashModel> servers;

    @Override
    public synchronized void setServers(List<? extends IHashModel> servers) {
        Validate.notEmpty(servers, "VipServer list cannot be empty!");
        this.servers = ConHashServerLocator.buildMap(servers);
    }

    private static TreeMap<Long, IHashModel> buildMap(Collection<? extends IHashModel> servers) {
        TreeMap<Long, IHashModel> newNodes = new TreeMap<Long, IHashModel>();
        for (IHashModel iHashModel : servers) {
            int numReps = iHashModel.getWeight() * 120;
            for (int i = 0; i < numReps / 4; ++i) {
                byte[] md5 = DigestUtils.md5(ConHashServerLocator.key(iHashModel, i));
                for (int h = 0; h < 4; ++h) {
                    Long k = ConHashServerLocator.getMd5BytesGroup(md5, h);
                    newNodes.put(k, iHashModel);
                }
            }
        }
        return newNodes;
    }

    private static long getMd5BytesGroup(byte[] md5, int i) {
        return (long)(md5[3 + i * 4] & 0xFF) << 24 | (long)(md5[2 + i * 4] & 0xFF) << 16 | (long)(md5[1 + i * 4] & 0xFF) << 8 | (long)(md5[i * 4] & 0xFF);
    }

    private static String key(IHashModel server, int repetition) {
        return server.getHost() + "-" + repetition;
    }

    @Override
    public IHashModel getServer(String key) {
        TreeMap<Long, IHashModel> localServers = this.servers;
        return ConHashServerLocator.getServer(key, localServers);
    }

    private static IHashModel getServer(String key, TreeMap<Long, IHashModel> localServers) {
        byte[] md5 = DigestUtils.md5(key);
        Long hash = ConHashServerLocator.getMd5BytesGroup(md5, 0);
        Map.Entry<Long, IHashModel> entry = localServers.ceilingEntry(hash);
        if (entry == null) {
            entry = localServers.firstEntry();
        }
        return entry.getValue();
    }

    public static IHashModel getTargetServer(String key, Collection<? extends IHashModel> servers) {
        return ConHashServerLocator.getServer(key, ConHashServerLocator.buildMap(servers));
    }
}

