/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.log;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.log.AbstractLogger;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingRequest;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingResponse;
import java.util.List;

public class SyncServerLogger
extends AbstractLogger {
    private static final SyncServerLogger instance = new SyncServerLogger();

    public static SyncServerLogger getInstance() {
        return instance;
    }

    private SyncServerLogger() {
        super(SyncServerLogger.class);
    }

    public void logOneTimeSyncNameList(VipServer server, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(One-time) nameList from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), server.getHost(), response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logOneTimeSyncVipDomain(String domain, VipServer server, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(One-time) vipDomain(%s) from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), domain, server.getHost(), response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logOneTimeSyncVipDomains(VipServer server, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(One-time) vipDomains from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), server.getHost(), response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logSync(VipServer server, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(Polling) from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), server.getHost(), response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logChangedVipDomains(List<VipDomain> vipDomains, int printCount, String antvipServer) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("(from VipServer(%s)) VipDomains changedCount:%s, (only first %d names):", antvipServer, vipDomains.size(), printCount));
        for (int i = 0; i < vipDomains.size() && i < printCount; ++i) {
            VipDomain domain = vipDomains.get(i);
            sb.append(domain.getName()).append("=").append(domain.getVersion()).append(",");
        }
        this.info(sb.toString());
    }

    public void logDeletedVipDomains(List<String> deletedDomains, String antvipServer) {
        this.info(String.format("(from VipServer(%s)) VipDomains deleted:%s", antvipServer, deletedDomains));
    }
}

