/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.TypeReference;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.parser.Feature;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.SerializeFilter;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.SerializerFeature;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.fastjson.AntvipJSON;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.log.DiskStoreLogger;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store.Store;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.thread.ThreadFactoryBuilder;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.AntVipFileUtils;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.AntVipUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DiskStore
implements Store {
    private static final String SERVER_LIST = "serverList";
    private static final String SERVER_LIST_HTTP = "serverListForHttp";
    public static final String ZONE_SERVERS_MAP = "zoneServersMap";
    public static final String ALL_STATION_SERVERS_MAP = "allStationServersMap";
    private static final String NAMELIST = "namelist";
    public static final String ISLAND_CHECK_DOMAINS = "islandCheckDomains";
    public static final String ZONE_INFO_LIST = "zoneInfoList";
    public static final String DNSFILTER_WHITE_LIST = "whiteList";
    public static final String DNSFILTER_BLACK_LIST = "blackList";
    public static final String DIVISION_BY_ENV0_DOMAINS = "divisionByEnv0Domains";
    private static final String TMP_EXTENSION = "tmp";
    private static final String JSON_EXTENSION = "json";
    private final ThreadPoolExecutor executor;
    private final File rootDiskStoreDir;
    private final File domainDiskStoreDir;
    private final SerializeFilter[] filters;

    public DiskStore(String diskStoreDir, SerializeFilter[] filters) {
        this.rootDiskStoreDir = new File(diskStoreDir);
        this.domainDiskStoreDir = new File(this.rootDiskStoreDir, "domains");
        this.mkdirs();
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        this.executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactoryBuilder.setNameFormat("AntVip-StoreExecutor").build());
        this.filters = filters;
    }

    private void mkdirs() {
        AntVipUtils.mkdirs(this.rootDiskStoreDir);
        AntVipUtils.mkdirs(this.domainDiskStoreDir);
    }

    @Override
    public List<String> loadDomainNameList() {
        List<String> list = new ArrayList<String>();
        File file = new File(this.rootDiskStoreDir, NAMELIST);
        if (file.exists()) {
            try {
                list = AntVipFileUtils.filterNote(file);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when loaded 'domainNameList' from disk, it's ignored and return empty.", new Object[0]);
            }
        }
        return list;
    }

    @Override
    public VipDomain loadVipDomain(String domainName) {
        File file = new File(this.domainDiskStoreDir, domainName + "." + JSON_EXTENSION);
        if (file.exists()) {
            try {
                String json = AntVipFileUtils.filterJsonNote(file);
                return JSON.parseObject(json, VipDomain.class);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when load VipDomain(%s) from disk, it's ignored", domainName);
            }
        }
        return null;
    }

    @Override
    public void onNameListChanged(List<String> domainNameList) {
        try {
            this.asyncStoreDomainNameList(domainNameList);
        }
        catch (Exception e) {
            DiskStoreLogger.getInstance().error(DiskStore.class, e, "Error when onNameListChanged(size is %s).", domainNameList.size());
        }
    }

    @Override
    public List<VipDomain> loadVipDomains() {
        ArrayList<VipDomain> list = new ArrayList<VipDomain>();
        Collection<File> files = FileUtils.listFiles(this.domainDiskStoreDir, new String[]{JSON_EXTENSION}, false);
        for (File file : files) {
            String json = null;
            try {
                json = AntVipFileUtils.filterJsonNote(file);
                VipDomain domain = JSON.parseObject(json, VipDomain.class);
                if (null == domain) continue;
                list.add(domain);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when loaded 'VipDomain'(%s) from disk, it's ignored, file content is: %s", file.getName(), json);
            }
        }
        DiskStoreLogger.getInstance().info("Loaded local VipDomains, size is %s", list.size());
        return list;
    }

    @Override
    public void onVipDomainChanged(List<VipDomain> vipDomains) {
        try {
            this.asyncStoreVipDomains(vipDomains);
        }
        catch (Exception e) {
            DiskStoreLogger.getInstance().error(DiskStore.class, e, "Error when onVipDomainChanged(vipDomains is %s).", vipDomains);
        }
    }

    @Override
    public void storeDomainNameList(List<String> domainNameList) throws IOException {
        this.mkdirs();
        DiskStoreLogger.getInstance().info("Store domainNameList, size is %s", domainNameList.size());
        String tmpFileName = "namelist.tmp";
        String desFileName = NAMELIST;
        AntVipFileUtils.storeLines(this.rootDiskStoreDir, tmpFileName, desFileName, domainNameList);
    }

    @Override
    public void asyncStoreDomainNameList(final List<String> domainNameList) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.storeDomainNameList(domainNameList);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when asyncStoreDomainNameList(size is %s)", domainNameList.size());
                }
            }
        });
    }

    @Override
    public void storeVipDomain(VipDomain vipDomain) throws IOException {
        this.mkdirs();
        DiskStoreLogger.getInstance().info("Store vipDomain: %s, version=%s", vipDomain.getName(), vipDomain.getVersion());
        String fileContent = AntvipJSON.toJSONString((Object)vipDomain, this.filters, new SerializerFeature[0]);
        String tmpFileName = vipDomain.getName() + "." + TMP_EXTENSION;
        String destFileName = vipDomain.getName() + "." + JSON_EXTENSION;
        AntVipFileUtils.storeJsonFile(this.domainDiskStoreDir, tmpFileName, destFileName, fileContent);
    }

    @Override
    public void asyncStoreVipDomain(final VipDomain vipDomain) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.storeVipDomain(vipDomain);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when asyncStoreVipDomain:%s", vipDomain.getName());
                }
            }
        });
    }

    @Override
    public void asyncStoreVipDomains(final List<VipDomain> vipDomains) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (VipDomain vipDomain : vipDomains) {
                    try {
                        DiskStore.this.storeVipDomain(vipDomain);
                    }
                    catch (Throwable e) {
                        DiskStoreLogger.getInstance().error(e, "Error when async store domain(%s) in asyncStoreVipDomains(), this domain is ignored.", vipDomain.getName());
                    }
                }
            }
        });
    }

    private List<VipServer> loadServers(String fileName) {
        ArrayList<VipServer> list = new ArrayList<VipServer>();
        File file = new File(this.rootDiskStoreDir, fileName + "." + JSON_EXTENSION);
        if (file.exists()) {
            try {
                String json = AntVipFileUtils.filterJsonNote(file);
                list = JSON.parseObject(json, new TypeReference<ArrayList<VipServer>>(){}, new Feature[0]);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when loaded '%s' from disk, it's ignored and return %s.", fileName, list);
            }
        }
        return list;
    }

    @Override
    public List<VipServer> loadServerList() throws IOException {
        return this.loadServers(SERVER_LIST);
    }

    @Override
    public List<VipServer> loadServerListForHttp() throws IOException {
        return this.loadServers(SERVER_LIST_HTTP);
    }

    @Override
    public List<String> loadStringList(String fileName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(this.rootDiskStoreDir, fileName + "." + JSON_EXTENSION);
        if (file.exists()) {
            try {
                String json = AntVipFileUtils.filterJsonNote(file);
                list = JSON.parseObject(json, new TypeReference<ArrayList<String>>(){}, new Feature[0]);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when loaded '%s' from disk, it's ignored and return %s.", fileName, list);
            }
        }
        return list;
    }

    @Override
    public Map<String, List<String>> loadZoneServersMap(String fileName) throws IOException {
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        File file = new File(this.rootDiskStoreDir, fileName + "." + JSON_EXTENSION);
        if (file.exists()) {
            try {
                String json = AntVipFileUtils.filterJsonNote(file);
                map = JSON.parseObject(json, new TypeReference<Map<String, List<String>>>(){}, new Feature[0]);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when loaded '%s' from disk, it's ignored and return %s.", fileName, map);
            }
        }
        return map;
    }

    @Override
    public Map<String, Map<String, List<String>>> loadAllStationServersMap(String fileName) throws IOException {
        Map<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>();
        File file = new File(this.rootDiskStoreDir, fileName + "." + JSON_EXTENSION);
        if (file.exists()) {
            try {
                String json = AntVipFileUtils.filterJsonNote(file);
                map = JSON.parseObject(json, new TypeReference<Map<String, Map<String, List<String>>>>(){}, new Feature[0]);
            }
            catch (Throwable e) {
                DiskStoreLogger.getInstance().error(e, "Error when loaded '%s' from disk, it's ignored and return %s.", fileName, map);
            }
        }
        return map;
    }

    public void storeServerList(List<VipServer> serverList, String fileName) throws IOException {
        this.mkdirs();
        DiskStoreLogger.getInstance().info("Store %s:%s", fileName, serverList);
        String tmpFileName = fileName + "." + TMP_EXTENSION;
        String desFileName = fileName + "." + JSON_EXTENSION;
        String fileContent = JSON.toJSONString(serverList);
        AntVipFileUtils.storeJsonFile(this.rootDiskStoreDir, tmpFileName, desFileName, fileContent);
    }

    public void storeStringList(List<String> stringList, String fileName) throws IOException {
        this.mkdirs();
        DiskStoreLogger.getInstance().info("Store %s TO file:%s", stringList, fileName);
        String fileContent = JSON.toJSONString(stringList);
        String tmpFileName = fileName + "." + TMP_EXTENSION;
        String desFileName = fileName + "." + JSON_EXTENSION;
        AntVipFileUtils.storeJsonFile(this.rootDiskStoreDir, tmpFileName, desFileName, fileContent);
    }

    public void storeMap(Map<String, ? extends Object> map, String fileName) throws IOException {
        this.mkdirs();
        DiskStoreLogger.getInstance().info("Store %s TO file:%s", map, fileName);
        String fileContent = JSON.toJSONString(map);
        String tmpFileName = fileName + "." + TMP_EXTENSION;
        String desFileName = fileName + "." + JSON_EXTENSION;
        AntVipFileUtils.storeJsonFile(this.rootDiskStoreDir, tmpFileName, desFileName, fileContent);
    }

    @Override
    public void asyncStoreMap(final Map<String, ? extends Object> map, final String fileName) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.storeMap(map, fileName);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when %s TO file:%s", map, fileName);
                }
            }
        });
    }

    @Override
    public void asyncStoreServerList(final List<VipServer> serverList) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.storeServerList(serverList, DiskStore.SERVER_LIST);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when asyncStoreServerList:%s", serverList);
                }
            }
        });
    }

    @Override
    public void asyncStoreServerListForHttp(final List<VipServer> serverList) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.storeServerList(serverList, DiskStore.SERVER_LIST_HTTP);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when asyncStoreServerList:%s", serverList);
                }
            }
        });
    }

    @Override
    public void asyncStoreStringList(final List<String> stringList, final String fileName) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.storeStringList(stringList, fileName);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when %s TO file:%s", stringList, fileName);
                }
            }
        });
    }

    @Override
    public void deleteVipDomain(String domainName) {
        DiskStoreLogger.getInstance().info("Deleted local VipDomain: %s", domainName);
        File file = new File(this.domainDiskStoreDir, domainName + "." + JSON_EXTENSION);
        FileUtils.deleteQuietly(file);
    }

    @Override
    public void asyncDeleteVipDomain(final String domainName) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStore.this.deleteVipDomain(domainName);
                }
                catch (Throwable e) {
                    DiskStoreLogger.getInstance().error(e, "Error when asyncDeleteVipDomain:%s", domainName);
                }
            }
        });
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        DiskStoreLogger.getInstance().info(DiskStore.class, "close.");
    }
}

