/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipException;
import com.alipay.sofa.sofamq.org.shade.apache.commons.io.FileUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.io.IOUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.time.DateFormatUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AntVipFileUtils {
    private static final String NOTE_PREFIX = "//";
    private static final String CHARSET_NAME = "UTF8";

    public static String filterJsonNote(File file) {
        String string;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            StringBuilder jsonBuilder = new StringBuilder();
            List<String> lines = IOUtils.readLines((InputStream)input, CHARSET_NAME);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                line = StringUtils.trimToNull(line);
                if (i == 0 && AntVipFileUtils.isNoteLine(line) || line == null) continue;
                jsonBuilder.append(line).append(' ');
            }
            string = jsonBuilder.toString();
        }
        catch (Throwable e) {
            try {
                throw new AntVipException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(input);
        return string;
    }

    public static List<String> filterNote(File file) {
        ArrayList<String> arrayList;
        ArrayList<String> values = new ArrayList<String>();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            List<String> lines = IOUtils.readLines((InputStream)input, CHARSET_NAME);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                line = StringUtils.trimToNull(line);
                if (i == 0 && AntVipFileUtils.isNoteLine(line) || line == null) continue;
                values.add(line);
            }
            arrayList = values;
        }
        catch (Throwable e) {
            try {
                throw new AntVipException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(input);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeJsonFile(File fileParent, String tmpFileName, String desFileName, String fileContent) throws IOException {
        File tempFile = new File(fileParent, tmpFileName);
        File destFile = new File(fileParent, desFileName);
        FileOutputStream output = new FileOutputStream(tempFile);
        try {
            IOUtils.write(AntVipFileUtils.genDateTimeNoteLine() + fileContent + IOUtils.LINE_SEPARATOR, (OutputStream)output, CHARSET_NAME);
            output.getChannel().force(true);
        }
        finally {
            output.close();
        }
        FileUtils.deleteQuietly(destFile);
        FileUtils.moveFile(tempFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeLines(File fileParent, String tmpFileName, String desFileName, List<String> lines) throws IOException {
        File tempFile = new File(fileParent, tmpFileName);
        File destFile = new File(fileParent, desFileName);
        FileOutputStream output = new FileOutputStream(tempFile);
        try {
            IOUtils.write(AntVipFileUtils.genDateTimeNoteLine(), (OutputStream)output);
            IOUtils.writeLines(lines, IOUtils.LINE_SEPARATOR, (OutputStream)output, CHARSET_NAME);
            output.getChannel().force(true);
        }
        finally {
            output.close();
        }
        FileUtils.deleteQuietly(destFile);
        FileUtils.moveFile(tempFile, destFile);
    }

    public static String genDateTimeNoteLine() {
        return NOTE_PREFIX + DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss,SSS") + IOUtils.LINE_SEPARATOR;
    }

    private static boolean isNoteLine(String line) {
        return line != null && line.startsWith(NOTE_PREFIX);
    }
}

