/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.RealNode;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingResponse;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.io.File;
import java.util.List;

public class AntVipUtils {
    private static final char SERVER_WEIGHT_SPLIT = ',';

    public static void resolvePollingResponse(PollingResponse vipResponse) {
        List<VipDomain> list;
        if (vipResponse != null && (list = vipResponse.getVipDomains()) != null) {
            for (VipDomain domain : list) {
                AntVipUtils.resolveVipDomain(domain);
            }
        }
    }

    public static void resolveVipDomain(VipDomain domain) {
        List<RealNode> realNodes;
        if (null != domain && (realNodes = domain.getRealNodes()) != null) {
            for (RealNode realNode : realNodes) {
                realNode.setVipDomain(domain);
            }
        }
    }

    public static List<VipServer> parseServerList(List<VipServer> list, List<Object> data, String skipHost) {
        if (data != null && !data.isEmpty()) {
            for (Object item : data) {
                String itemStr = (String)item;
                String[] split = StringUtils.split(itemStr, ',');
                String host = split[0];
                if (skipHost != null && StringUtils.equalsIgnoreCase(host, skipHost)) continue;
                VipServer server = new VipServer(host);
                if (split.length > 1) {
                    int weight = Integer.parseInt(split[1]);
                    server.setWeight(weight);
                }
                list.add(server);
            }
        }
        return list;
    }

    public static String convertToConfigString(VipServer server) {
        return server.getHost() + ',' + server.getWeight();
    }

    public static void mkdirs(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs() && !dir.exists()) {
                throw new AntVipException(String.format("Directory(%s) created failed!", dir.getPath()));
            }
        } else if (!dir.isDirectory()) {
            throw new AntVipException(String.format("Directory(%s) exists but it's not directory!", dir.getPath()));
        }
    }
}

