/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.RealNode;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingRequest;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.transport.PollingResponse;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class AntvipDirectRequestUtil {
    public static List<String> parseToHealthIps(String data, String domainName) {
        List<RealNode> realNodes = AntvipDirectRequestUtil.parseToRealNodes(data, domainName);
        ArrayList<String> ips = new ArrayList<String>();
        for (RealNode realNode : realNodes) {
            if (!realNode.isAvailable()) continue;
            ips.add(realNode.getIp());
        }
        return ips;
    }

    public static List<String> parseToAllIps(String data, String domainName) {
        List<RealNode> realNodes = AntvipDirectRequestUtil.parseToRealNodes(data, domainName);
        ArrayList<String> ips = new ArrayList<String>();
        for (RealNode realNode : realNodes) {
            ips.add(realNode.getIp());
        }
        return ips;
    }

    public static List<RealNode> parseToRealNodes(String data, String domainName) {
        VipDomain vipDomain = AntvipDirectRequestUtil.parseToVipDomain(data, domainName);
        if (null == vipDomain || null == vipDomain.getRealNodes()) {
            return new ArrayList<RealNode>();
        }
        return vipDomain.getRealNodes();
    }

    public static VipDomain parseToVipDomain(String data, String domainName) {
        PollingResponse pollingResponse = JSON.parseObject(data, PollingResponse.class);
        if (null != pollingResponse.getVipDomains()) {
            for (VipDomain vipDomain : pollingResponse.getVipDomains()) {
                if (!StringUtils.equals(domainName, vipDomain.getName())) continue;
                return vipDomain;
            }
        }
        return null;
    }

    public static PollingResponse parseToPollingResponse(String data) {
        return JSON.parseObject(data, PollingResponse.class);
    }

    public static String buildVipDomainRequestJson(String domain, String appName) {
        return JSON.toJSONString(AntvipDirectRequestUtil.buildVipDomainRequest(domain, appName));
    }

    public static String buildVipDomainsRequestJson(Collection<String> domainList, String appName) {
        return JSON.toJSONString(AntvipDirectRequestUtil.buildVipDomainsRequest(domainList, appName));
    }

    public static PollingRequest buildVipDomainRequest(String domain, String appName) {
        if (StringUtils.isEmpty(domain)) {
            throw new IllegalArgumentException("domain should not be empty");
        }
        PollingRequest request = AntvipDirectRequestUtil.buildBase(appName);
        HashMap<String, String> vipDomainName2ChecksumMap = new HashMap<String, String>();
        vipDomainName2ChecksumMap.put(domain, "N");
        request.setVipDomainName2ChecksumMap(vipDomainName2ChecksumMap);
        return request;
    }

    public static PollingRequest buildVipDomainsRequest(Collection<String> domainList, String appName) {
        if (null == domainList || domainList.isEmpty()) {
            throw new IllegalArgumentException("domainList should not be empty");
        }
        PollingRequest request = AntvipDirectRequestUtil.buildBase(appName);
        HashMap<String, String> vipDomainName2ChecksumMap = new HashMap<String, String>();
        for (String domain : domainList) {
            if (StringUtils.isEmpty(domain)) {
                throw new IllegalArgumentException("domain should not be empty");
            }
            vipDomainName2ChecksumMap.put(domain, "N");
        }
        request.setVipDomainName2ChecksumMap(vipDomainName2ChecksumMap);
        return request;
    }

    private static PollingRequest buildBase(String appName) {
        PollingRequest request = new PollingRequest();
        request.setAllowPolling(false);
        request.setFrom(appName + "-client");
        request.setStartTime(System.currentTimeMillis());
        request.setClientVersion("direct_http_json");
        return request;
    }
}

