/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.HealthCheckType;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.RealNode;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import java.util.List;
import java.util.Map;

public class ChecksumUtils {
    public static String checksumForClient(VipDomain vipDomain) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (vipDomain.getName() == null ? 0 : vipDomain.getName().hashCode());
        result = 31 * result + vipDomain.getProtectThreshold();
        result = 31 * result + (vipDomain.getRealNodes() == null ? 0 : ChecksumUtils.hashCodeForClient(vipDomain.getRealNodes()));
        return String.valueOf(result);
    }

    private static int hashCodeForClient(List<RealNode> realNodes) {
        if (realNodes == null) {
            return 0;
        }
        int result = 1;
        for (RealNode realNode : realNodes) {
            result = 31 * result + (realNode == null ? 0 : ChecksumUtils.hashCodeForClient(realNode));
        }
        return result;
    }

    private static int hashCodeForClient(RealNode realNode) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (realNode.getAvailable() == null ? 0 : realNode.getAvailable().hashCode());
        result = 31 * result + (realNode.getIp() == null ? 0 : realNode.getIp().hashCode());
        result = 31 * result + realNode.getWeight();
        return result;
    }

    public static String checksumForServer(VipDomain vipDomain) {
        int prime = 31;
        int result = 1;
        result = 31 * result + vipDomain.getHealthCheckDefaultPort();
        result = 31 * result + vipDomain.getHealthCheckInterval();
        Map<String, Object> healthCheckPayload = vipDomain.getHealthCheckPayload();
        result = 31 * result + (healthCheckPayload == null ? 0 : healthCheckPayload.hashCode());
        result = 31 * result + vipDomain.getHealthCheckRaise();
        result = 31 * result + vipDomain.getHealthCheckFall();
        result = 31 * result + vipDomain.getHealthCheckTimeout();
        HealthCheckType healthCheckType = vipDomain.getHealthCheckType();
        result = 31 * result + (healthCheckType == null ? 0 : healthCheckType.getName().hashCode());
        String name = vipDomain.getName();
        result = 31 * result + (name == null ? 0 : name.hashCode());
        result = 31 * result + vipDomain.getProtectThreshold();
        result = 31 * result + (int)(vipDomain.getVersion() ^ vipDomain.getVersion() >>> 32);
        List<RealNode> realNodes = vipDomain.getRealNodes();
        result = 31 * result + (realNodes == null ? 0 : ChecksumUtils.hashCodeForServer(realNodes));
        return String.valueOf(result);
    }

    private static int hashCodeForServer(List<RealNode> realNodes) {
        if (realNodes == null) {
            return 0;
        }
        int result = 1;
        for (RealNode realNode : realNodes) {
            result = 31 * result + (realNode == null ? 0 : ChecksumUtils.hashCodeForServer(realNode));
        }
        return result;
    }

    private static int hashCodeForServer(RealNode realNode) {
        int prime = 31;
        int result = 1;
        Boolean available = realNode.getAvailable();
        result = 31 * result + (available == null ? 0 : available.hashCode());
        String ip = realNode.getIp();
        result = 31 * result + (ip == null ? 0 : ip.hashCode());
        Integer healthCheckPort = realNode.getHealthCheckPort();
        result = 31 * result + (healthCheckPort == null ? 0 : healthCheckPort.hashCode());
        result = 31 * result + realNode.getWeight();
        return result;
    }

    public static String checksum(List<String> nameList) {
        if (nameList == null || nameList.size() == 0) {
            return "N";
        }
        String checksum = String.valueOf(nameList.hashCode());
        return checksum;
    }

    public static String checksumForMap(Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return "N";
        }
        return String.valueOf(map.hashCode());
    }
}

