/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.sofa.common.log.factory;

import com.alipay.sofa.sofamq.com.shade.alipay.sofa.common.log.AssertUtil;
import com.alipay.sofa.sofamq.com.shade.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.sofamq.com.shade.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.sofamq.com.shade.alipay.sofa.common.log.factory.LoggerSpaceFactoryBuilder;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggerSpaceFactoryBuilder
implements LoggerSpaceFactoryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoggerSpaceFactoryBuilder.class);
    private SpaceInfo spaceInfo;

    public AbstractLoggerSpaceFactoryBuilder(SpaceInfo space) {
        AssertUtil.notNull(space);
        this.spaceInfo = space;
    }

    @Override
    public AbstractLoggerSpaceFactory build(String spaceName, ClassLoader spaceClassloader) {
        AssertUtil.hasText(spaceName);
        AssertUtil.notNull(spaceClassloader);
        URL configFileUrl = spaceClassloader.getResource(this.getSpaceLogConfigFile(spaceName));
        AssertUtil.state(configFileUrl != null, this + " build error: No " + this.getLoggingToolName() + " config file (" + configFileUrl + ") found!");
        this.specifySpaceLogConfigProperites(spaceName);
        return this.doBuild(spaceName, spaceClassloader, configFileUrl);
    }

    private String getSpaceLogConfigFile(String spaceName) {
        return spaceName.replace('.', '/') + "/" + "log" + "/" + this.getLoggingToolName() + "/" + "log-conf.xml";
    }

    private void specifySpaceLogConfigProperites(String spaceName) {
        String loggingLevelKey;
        Iterator<Map.Entry<Object, Object>> iterator = this.spaceInfo.properties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!System.getProperties().containsKey(entry.getKey())) continue;
            iterator.remove();
            logger.warn("Props key {}  is also already existed in System.getProps ({}:{}),so use it!", new Object[]{entry.getKey(), entry.getKey(), System.getProperty((String)entry.getKey())});
        }
        String loggingPathKey = "logging.path." + spaceName;
        if (System.getProperty(loggingPathKey) == null && System.getProperty("logging.path") != null && this.spaceInfo.properties().getProperty(loggingPathKey) == null) {
            this.spaceInfo.properties().setProperty(loggingPathKey, System.getProperty("logging.path"));
        }
        if (System.getProperty(loggingLevelKey = "logging.level." + spaceName) == null && this.spaceInfo.properties().getProperty(loggingLevelKey) == null) {
            this.spaceInfo.properties().setProperty(loggingLevelKey, "INFO");
        }
    }

    protected abstract AbstractLoggerSpaceFactory doBuild(String var1, ClassLoader var2, URL var3);

    protected abstract String getLoggingToolName();

    protected Properties getProperties() {
        return this.spaceInfo.properties();
    }
}

