/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.google.common.collect;

import com.alipay.sofa.sofamq.com.shade.google.common.annotations.GwtCompatible;
import com.alipay.sofa.sofamq.com.shade.google.common.base.Preconditions;
import com.alipay.sofa.sofamq.com.shade.google.common.collect.AbstractIterator;
import com.alipay.sofa.sofamq.com.shade.google.common.collect.Lists;
import java.util.Collections;
import java.util.Queue;

@GwtCompatible
class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = Lists.newLinkedList();
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return this.queue.isEmpty() ? this.endOfData() : this.queue.remove();
    }
}

