/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.io.shade.netty.channel;

import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBuf;
import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBufAllocator;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelFuture;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelFutureListener;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelHandlerContext;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelOutboundInvoker;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelPromise;
import com.alipay.sofa.sofamq.io.shade.netty.channel.DelegatingChannelPromiseNotifier;
import com.alipay.sofa.sofamq.io.shade.netty.util.ReferenceCountUtil;
import com.alipay.sofa.sofamq.io.shade.netty.util.internal.ObjectUtil;
import com.alipay.sofa.sofamq.io.shade.netty.util.internal.logging.InternalLogger;
import com.alipay.sofa.sofamq.io.shade.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private int readableBytes;

    public AbstractCoalescingBufferQueue(int initSize) {
        this.bufAndListenerPairs = new ArrayDeque(initSize);
    }

    public final void addFirst(ByteBuf buf) {
        this.incrementReadableBytes(buf.readableBytes());
        this.bufAndListenerPairs.addFirst(buf);
    }

    public final void add(ByteBuf buf) {
        this.add(buf, (ChannelFutureListener)null);
    }

    public final void add(ByteBuf buf, ChannelPromise promise) {
        this.add(buf, promise.isVoid() ? null : new DelegatingChannelPromiseNotifier(promise));
    }

    public final void add(ByteBuf buf, ChannelFutureListener listener) {
        this.incrementReadableBytes(buf.readableBytes());
        this.bufAndListenerPairs.add(buf);
        if (listener != null) {
            this.bufAndListenerPairs.add(listener);
        }
    }

    public final ByteBuf removeFirst(ChannelPromise aggregatePromise) {
        Object entry = this.bufAndListenerPairs.poll();
        if (entry == null) {
            return null;
        }
        assert (entry instanceof ByteBuf);
        ByteBuf result = (ByteBuf)entry;
        this.readableBytes -= result.readableBytes();
        assert (this.readableBytes >= 0);
        entry = this.bufAndListenerPairs.peek();
        if (entry instanceof ChannelFutureListener) {
            aggregatePromise.addListener((ChannelFutureListener)entry);
            this.bufAndListenerPairs.poll();
        }
        return result;
    }

    public final ByteBuf remove(ByteBufAllocator alloc, int bytes, ChannelPromise aggregatePromise) {
        Object entry;
        ObjectUtil.checkPositiveOrZero(bytes, "bytes");
        ObjectUtil.checkNotNull(aggregatePromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            return this.removeEmptyValue();
        }
        bytes = Math.min(bytes, this.readableBytes);
        ByteBuf toReturn = null;
        int originalBytes = bytes;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            if (entry instanceof ChannelFutureListener) {
                aggregatePromise.addListener((ChannelFutureListener)entry);
                continue;
            }
            ByteBuf entryBuffer = (ByteBuf)entry;
            if (entryBuffer.readableBytes() > bytes) {
                this.bufAndListenerPairs.addFirst(entryBuffer);
                if (bytes <= 0) break;
                ByteBuf next = entryBuffer.readRetainedSlice(bytes);
                toReturn = toReturn == null ? this.composeFirst(alloc, next) : this.compose(alloc, toReturn, next);
                bytes = 0;
                break;
            }
            bytes -= entryBuffer.readableBytes();
            toReturn = toReturn == null ? this.composeFirst(alloc, entryBuffer) : this.compose(alloc, toReturn, entryBuffer);
        }
        this.readableBytes -= originalBytes - bytes;
        assert (this.readableBytes >= 0);
        return toReturn;
    }

    public final int readableBytes() {
        return this.readableBytes;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public final void releaseAndFailAll(ChannelOutboundInvoker invoker, Throwable cause) {
        this.releaseAndCompleteAll(invoker.newFailedFuture(cause));
    }

    public final void copyTo(AbstractCoalescingBufferQueue dest) {
        dest.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        dest.readableBytes += this.readableBytes;
    }

    public final void writeAndRemoveAll(ChannelHandlerContext ctx) {
        this.readableBytes = 0;
        Throwable pending = null;
        ByteBuf previousBuf = null;
        while (true) {
            Object entry = this.bufAndListenerPairs.poll();
            try {
                if (entry == null) {
                    if (previousBuf == null) break;
                    ctx.write(previousBuf, ctx.voidPromise());
                    break;
                }
                if (entry instanceof ByteBuf) {
                    if (previousBuf != null) {
                        ctx.write(previousBuf, ctx.voidPromise());
                    }
                    previousBuf = (ByteBuf)entry;
                    continue;
                }
                if (entry instanceof ChannelPromise) {
                    ctx.write(previousBuf, (ChannelPromise)entry);
                    previousBuf = null;
                    continue;
                }
                ctx.write(previousBuf).addListener((ChannelFutureListener)entry);
                previousBuf = null;
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    protected abstract ByteBuf compose(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);

    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first) {
        return first;
    }

    protected abstract ByteBuf removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    private void releaseAndCompleteAll(ChannelFuture future) {
        Object entry;
        this.readableBytes = 0;
        Throwable pending = null;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (entry instanceof ByteBuf) {
                    ReferenceCountUtil.safeRelease(entry);
                    continue;
                }
                ((ChannelFutureListener)entry).operationComplete(future);
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    private void incrementReadableBytes(int increment) {
        int nextReadableBytes = this.readableBytes + increment;
        if (nextReadableBytes < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + increment);
        }
        this.readableBytes = nextReadableBytes;
    }
}

