/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.io.shade.netty.channel;

import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBuf;
import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBufAllocator;
import com.alipay.sofa.sofamq.io.shade.netty.buffer.CompositeByteBuf;
import com.alipay.sofa.sofamq.io.shade.netty.buffer.Unpooled;
import com.alipay.sofa.sofamq.io.shade.netty.channel.AbstractCoalescingBufferQueue;
import com.alipay.sofa.sofamq.io.shade.netty.channel.Channel;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelPromise;
import com.alipay.sofa.sofamq.io.shade.netty.util.internal.ObjectUtil;

public final class CoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final Channel channel;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int initSize) {
        super(initSize);
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    public ByteBuf remove(int bytes, ChannelPromise aggregatePromise) {
        return this.remove(this.channel.alloc(), bytes, aggregatePromise);
    }

    public void releaseAndFailAll(Throwable cause) {
        this.releaseAndFailAll(this.channel, cause);
    }

    @Override
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        if (cumulation instanceof CompositeByteBuf) {
            CompositeByteBuf composite = (CompositeByteBuf)cumulation;
            composite.addComponent(true, next);
            return composite;
        }
        CompositeByteBuf composite = alloc.compositeBuffer(this.size() + 2);
        composite.addComponent(true, cumulation);
        composite.addComponent(true, next);
        return composite;
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return Unpooled.EMPTY_BUFFER;
    }
}

