/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http2;

import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBuf;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelHandler;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelHandlerContext;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.base64.Base64;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.base64.Base64Dialect;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http.FullHttpResponse;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http.HttpClientUpgradeHandler;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http.HttpRequest;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http2.Http2CodecUtil;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http2.Http2ConnectionHandler;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http2.Http2FrameCodec;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.http2.Http2Settings;
import com.alipay.sofa.sofamq.io.shade.netty.util.CharsetUtil;
import com.alipay.sofa.sofamq.io.shade.netty.util.ReferenceCountUtil;
import com.alipay.sofa.sofamq.io.shade.netty.util.collection.CharObjectMap;
import com.alipay.sofa.sofamq.io.shade.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;

    public Http2ClientUpgradeCodec(Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(null, frameCodec, upgradeToHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(handlerName, (Http2ConnectionHandler)frameCodec, upgradeToHandler);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this((String)null, connectionHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        this(handlerName, connectionHandler, (ChannelHandler)connectionHandler);
    }

    private Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler upgradeToHandler) {
        this.handlerName = handlerName;
        this.connectionHandler = ObjectUtil.checkNotNull(connectionHandler, "connectionHandler");
        this.upgradeToHandler = ObjectUtil.checkNotNull(upgradeToHandler, "upgradeToHandler");
    }

    @Override
    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        CharSequence settingsValue = this.getSettingsHeaderValue(ctx);
        upgradeRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, (Object)settingsValue);
        return UPGRADE_HEADERS;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        this.connectionHandler.onHttpClientUpgrade();
        ctx.pipeline().addAfter(ctx.name(), this.handlerName, this.upgradeToHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getSettingsHeaderValue(ChannelHandlerContext ctx) {
        String string;
        ByteBuf buf = null;
        ByteBuf encodedBuf = null;
        try {
            Http2Settings settings = this.connectionHandler.decoder().localSettings();
            int payloadLength = 6 * settings.size();
            buf = ctx.alloc().buffer(payloadLength);
            for (CharObjectMap.PrimitiveEntry entry : settings.entries()) {
                buf.writeChar(entry.key());
                buf.writeInt(((Long)entry.value()).intValue());
            }
            encodedBuf = Base64.encode(buf, Base64Dialect.URL_SAFE);
            string = encodedBuf.toString(CharsetUtil.UTF_8);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            ReferenceCountUtil.release(encodedBuf);
            throw throwable;
        }
        ReferenceCountUtil.release(buf);
        ReferenceCountUtil.release(encodedBuf);
        return string;
    }
}

