/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.log.ClientLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import java.util.Set;
import java.util.TreeSet;

public class MQHelper {
    public static void resetOffsetByTimestamp(MessageModel messageModel, String consumerGroup, String topic, long timestamp) throws Exception {
        MQHelper.resetOffsetByTimestamp(messageModel, "DEFAULT", consumerGroup, topic, timestamp);
    }

    public static void resetOffsetByTimestamp(MessageModel messageModel, String instanceName, String consumerGroup, String topic, long timestamp) throws Exception {
        InternalLogger log = ClientLogger.getLog();
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer(consumerGroup);
        consumer.setInstanceName(instanceName);
        consumer.setMessageModel(messageModel);
        consumer.start();
        Set<MessageQueue> mqs = null;
        try {
            mqs = consumer.fetchSubscribeMessageQueues(topic);
            if (mqs != null && !mqs.isEmpty()) {
                TreeSet<MessageQueue> mqsNew = new TreeSet<MessageQueue>(mqs);
                for (MessageQueue mq : mqsNew) {
                    long offset = consumer.searchOffset(mq, timestamp);
                    if (offset < 0L) continue;
                    consumer.updateConsumeOffset(mq, offset);
                    log.info("resetOffsetByTimestamp updateConsumeOffset success, {} {} {}", consumerGroup, offset, mq);
                }
            }
        }
        catch (Exception e) {
            log.warn("resetOffsetByTimestamp Exception", e);
            throw e;
        }
        finally {
            if (mqs != null) {
                consumer.getDefaultMQPullConsumerImpl().getOffsetStore().persistAll(mqs);
            }
            consumer.shutdown();
        }
    }
}

