/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.MessageQueueListener;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.PullTaskCallback;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.PullTaskContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQClientException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.log.ClientLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.ThreadFactoryImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.NamespaceUtil;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.RPCHook;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MQPullConsumerScheduleService {
    private final InternalLogger log = ClientLogger.getLog();
    private final MessageQueueListener messageQueueListener = new MessageQueueListenerImpl();
    private final ConcurrentMap<MessageQueue, PullTaskImpl> taskTable = new ConcurrentHashMap<MessageQueue, PullTaskImpl>();
    private DefaultMQPullConsumer defaultMQPullConsumer;
    private int pullThreadNums = 20;
    private ConcurrentMap<String, PullTaskCallback> callbackTable = new ConcurrentHashMap<String, PullTaskCallback>();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    public MQPullConsumerScheduleService(String consumerGroup) {
        this.defaultMQPullConsumer = new DefaultMQPullConsumer(consumerGroup);
        this.defaultMQPullConsumer.setMessageModel(MessageModel.CLUSTERING);
    }

    public MQPullConsumerScheduleService(String consumerGroup, RPCHook rpcHook) {
        this.defaultMQPullConsumer = new DefaultMQPullConsumer(consumerGroup, rpcHook);
        this.defaultMQPullConsumer.setMessageModel(MessageModel.CLUSTERING);
    }

    public void putTask(String topic, Set<MessageQueue> mqNewSet) {
        Iterator it = this.taskTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!((MessageQueue)next.getKey()).getTopic().equals(topic) || mqNewSet.contains(next.getKey())) continue;
            ((PullTaskImpl)next.getValue()).setCancelled(true);
            it.remove();
        }
        for (MessageQueue mq : mqNewSet) {
            if (this.taskTable.containsKey(mq)) continue;
            PullTaskImpl command = new PullTaskImpl(mq);
            this.taskTable.put(mq, command);
            this.scheduledThreadPoolExecutor.schedule(command, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public void start() throws MQClientException {
        String group = this.defaultMQPullConsumer.getConsumerGroup();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.pullThreadNums, new ThreadFactoryImpl("PullMsgThread-" + group));
        this.defaultMQPullConsumer.setMessageQueueListener(this.messageQueueListener);
        this.defaultMQPullConsumer.start();
        this.log.info("MQPullConsumerScheduleService start OK, {} {}", (Object)this.defaultMQPullConsumer.getConsumerGroup(), (Object)this.callbackTable);
    }

    public void registerPullTaskCallback(String topic, PullTaskCallback callback) {
        this.callbackTable.put(NamespaceUtil.wrapNamespace(this.defaultMQPullConsumer.getNamespace(), topic), callback);
        this.defaultMQPullConsumer.registerMessageQueueListener(topic, null);
    }

    public void shutdown() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
        }
        if (this.defaultMQPullConsumer != null) {
            this.defaultMQPullConsumer.shutdown();
        }
    }

    public ConcurrentMap<String, PullTaskCallback> getCallbackTable() {
        return this.callbackTable;
    }

    public void setCallbackTable(ConcurrentHashMap<String, PullTaskCallback> callbackTable) {
        this.callbackTable = callbackTable;
    }

    public int getPullThreadNums() {
        return this.pullThreadNums;
    }

    public void setPullThreadNums(int pullThreadNums) {
        this.pullThreadNums = pullThreadNums;
    }

    public DefaultMQPullConsumer getDefaultMQPullConsumer() {
        return this.defaultMQPullConsumer;
    }

    public void setDefaultMQPullConsumer(DefaultMQPullConsumer defaultMQPullConsumer) {
        this.defaultMQPullConsumer = defaultMQPullConsumer;
    }

    public MessageModel getMessageModel() {
        return this.defaultMQPullConsumer.getMessageModel();
    }

    public void setMessageModel(MessageModel messageModel) {
        this.defaultMQPullConsumer.setMessageModel(messageModel);
    }

    public class PullTaskImpl
    implements Runnable {
        private final MessageQueue messageQueue;
        private volatile boolean cancelled = false;

        public PullTaskImpl(MessageQueue messageQueue) {
            this.messageQueue = messageQueue;
        }

        @Override
        public void run() {
            String topic = this.messageQueue.getTopic();
            if (!this.isCancelled()) {
                PullTaskCallback pullTaskCallback = (PullTaskCallback)MQPullConsumerScheduleService.this.callbackTable.get(topic);
                if (pullTaskCallback != null) {
                    PullTaskContext context = new PullTaskContext();
                    context.setPullConsumer(MQPullConsumerScheduleService.this.defaultMQPullConsumer);
                    try {
                        pullTaskCallback.doPullTask(this.messageQueue, context);
                    }
                    catch (Throwable e) {
                        context.setPullNextDelayTimeMillis(1000);
                        MQPullConsumerScheduleService.this.log.error("doPullTask Exception", e);
                    }
                    if (!this.isCancelled()) {
                        MQPullConsumerScheduleService.this.scheduledThreadPoolExecutor.schedule(this, (long)context.getPullNextDelayTimeMillis(), TimeUnit.MILLISECONDS);
                    } else {
                        MQPullConsumerScheduleService.this.log.warn("The Pull Task is cancelled after doPullTask, {}", (Object)this.messageQueue);
                    }
                } else {
                    MQPullConsumerScheduleService.this.log.warn("Pull Task Callback not exist , {}", (Object)topic);
                }
            } else {
                MQPullConsumerScheduleService.this.log.warn("The Pull Task is cancelled, {}", (Object)this.messageQueue);
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public MessageQueue getMessageQueue() {
            return this.messageQueue;
        }
    }

    class MessageQueueListenerImpl
    implements MessageQueueListener {
        MessageQueueListenerImpl() {
        }

        @Override
        public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
            MessageModel messageModel = MQPullConsumerScheduleService.this.defaultMQPullConsumer.getMessageModel();
            switch (messageModel) {
                case BROADCASTING: {
                    MQPullConsumerScheduleService.this.putTask(topic, mqAll);
                    break;
                }
                case CLUSTERING: {
                    MQPullConsumerScheduleService.this.putTask(topic, mqDivided);
                    break;
                }
            }
        }
    }
}

