/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.rebalance;

import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.log.ClientLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class AllocateMachineRoomNearby
implements AllocateMessageQueueStrategy {
    private final InternalLogger log = ClientLogger.getLog();
    private final AllocateMessageQueueStrategy allocateMessageQueueStrategy;
    private final MachineRoomResolver machineRoomResolver;

    public AllocateMachineRoomNearby(AllocateMessageQueueStrategy allocateMessageQueueStrategy, MachineRoomResolver machineRoomResolver) throws NullPointerException {
        if (allocateMessageQueueStrategy == null) {
            throw new NullPointerException("allocateMessageQueueStrategy is null");
        }
        if (machineRoomResolver == null) {
            throw new NullPointerException("machineRoomResolver is null");
        }
        this.allocateMessageQueueStrategy = allocateMessageQueueStrategy;
        this.machineRoomResolver = machineRoomResolver;
    }

    @Override
    public List<MessageQueue> allocate(String consumerGroup, String currentCID, List<MessageQueue> mqAll, List<String> cidAll) {
        if (currentCID == null || currentCID.length() < 1) {
            throw new IllegalArgumentException("currentCID is empty");
        }
        if (mqAll == null || mqAll.isEmpty()) {
            throw new IllegalArgumentException("mqAll is null or mqAll empty");
        }
        if (cidAll == null || cidAll.isEmpty()) {
            throw new IllegalArgumentException("cidAll is null or cidAll empty");
        }
        ArrayList<MessageQueue> result = new ArrayList<MessageQueue>();
        if (!cidAll.contains(currentCID)) {
            this.log.info("[BUG] ConsumerGroup: {} The consumerId: {} not in cidAll: {}", consumerGroup, currentCID, cidAll);
            return result;
        }
        TreeMap mr2Mq = new TreeMap();
        for (MessageQueue messageQueue : mqAll) {
            String brokerMachineRoom = this.machineRoomResolver.brokerDeployIn(messageQueue);
            if (StringUtils.isNoneEmpty(brokerMachineRoom)) {
                if (mr2Mq.get(brokerMachineRoom) == null) {
                    mr2Mq.put(brokerMachineRoom, new ArrayList());
                }
                ((List)mr2Mq.get(brokerMachineRoom)).add(messageQueue);
                continue;
            }
            throw new IllegalArgumentException("Machine room is null for mq " + messageQueue);
        }
        TreeMap mr2c = new TreeMap();
        for (String cid : cidAll) {
            String consumerMachineRoom = this.machineRoomResolver.consumerDeployIn(cid);
            if (StringUtils.isNoneEmpty(consumerMachineRoom)) {
                if (mr2c.get(consumerMachineRoom) == null) {
                    mr2c.put(consumerMachineRoom, new ArrayList());
                }
                ((List)mr2c.get(consumerMachineRoom)).add(cid);
                continue;
            }
            throw new IllegalArgumentException("Machine room is null for consumer id " + cid);
        }
        ArrayList<MessageQueue> arrayList = new ArrayList<MessageQueue>();
        String currentMachineRoom = this.machineRoomResolver.consumerDeployIn(currentCID);
        List mqInThisMachineRoom = (List)mr2Mq.remove(currentMachineRoom);
        List consumerInThisMachineRoom = (List)mr2c.get(currentMachineRoom);
        if (mqInThisMachineRoom != null && !mqInThisMachineRoom.isEmpty()) {
            arrayList.addAll(this.allocateMessageQueueStrategy.allocate(consumerGroup, currentCID, mqInThisMachineRoom, consumerInThisMachineRoom));
        }
        for (String machineRoom : mr2Mq.keySet()) {
            if (mr2c.containsKey(machineRoom)) continue;
            arrayList.addAll(this.allocateMessageQueueStrategy.allocate(consumerGroup, currentCID, (List)mr2Mq.get(machineRoom), cidAll));
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return "MACHINE_ROOM_NEARBY-" + this.allocateMessageQueueStrategy.getName();
    }

    public static interface MachineRoomResolver {
        public String brokerDeployIn(MessageQueue var1);

        public String consumerDeployIn(String var1);
    }
}

