/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl;

import com.alipay.sofa.sofamq.io.shade.netty.channel.EventLoopGroup;
import com.alipay.sofa.sofamq.io.shade.netty.util.concurrent.EventExecutorGroup;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.ClientConfig;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.factory.MQClientInstance;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.log.ClientLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.RPCHook;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MQClientManager {
    private static final InternalLogger log = ClientLogger.getLog();
    private static MQClientManager instance = new MQClientManager();
    private AtomicInteger factoryIndexGenerator = new AtomicInteger();
    private ConcurrentMap<String, MQClientInstance> factoryTable = new ConcurrentHashMap<String, MQClientInstance>();

    private MQClientManager() {
    }

    public static MQClientManager getInstance() {
        return instance;
    }

    public MQClientInstance getOrCreateMQClientInstance(ClientConfig clientConfig) {
        return this.getOrCreateMQClientInstance(clientConfig, null);
    }

    public MQClientInstance getOrCreateMQClientInstance(ClientConfig clientConfig, RPCHook rpcHook) {
        return this.getOrCreateMQClientInstance(clientConfig, rpcHook, null, null);
    }

    public MQClientInstance getOrCreateMQClientInstance(ClientConfig clientConfig, RPCHook rpcHook, EventLoopGroup eventLoopGroup, EventExecutorGroup eventExecutorGroup) {
        String clientId = clientConfig.buildMQClientId();
        MQClientInstance instance = (MQClientInstance)this.factoryTable.get(clientId);
        if (null == instance) {
            instance = new MQClientInstance(clientConfig.cloneClientConfig(), this.factoryIndexGenerator.getAndIncrement(), clientId, rpcHook, eventLoopGroup, eventExecutorGroup);
            MQClientInstance prev = this.factoryTable.putIfAbsent(clientId, instance);
            if (prev != null) {
                instance = prev;
                log.warn("Returned Previous MQClientInstance for clientId:[{}]", (Object)clientId);
            } else {
                log.info("Created new MQClientInstance for clientId:[{}]", (Object)clientId);
            }
        }
        return instance;
    }

    public void removeClientFactory(String clientId) {
        this.factoryTable.remove(clientId);
    }
}

