/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer;

import com.alipay.sofa.sofamq.io.shade.netty.channel.EventLoopGroup;
import com.alipay.sofa.sofamq.io.shade.netty.util.concurrent.EventExecutorGroup;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.RandomUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.ClientConfig;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.QueryResult;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.Validators;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQBrokerException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQClientException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.RequestTimeoutException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.log.ClientLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.LocalTransactionExecuter;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.MQProducer;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.MessageQueueSelector;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.RequestCallback;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendCallback;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendResult;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.TransactionSendResult;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.AsyncTraceDispatcher;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceDispatcher;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.hook.SendMessageTraceHookImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.ServiceState;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.Message;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageBatch;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageClientIDSetter;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageDecoder;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageId;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.RPCHook;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.exception.RemotingException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class DefaultMQProducer
extends ClientConfig
implements MQProducer {
    protected transient DefaultMQProducerImpl defaultMQProducerImpl;
    private final InternalLogger log = ClientLogger.getLog();
    protected String producerGroup;
    private String createTopicKey = "TBW102";
    private volatile int defaultTopicQueueNums = 4;
    private int sendMsgTimeout = 3000;
    private int compressMsgBodyOverHowmuch = 4096;
    private int retryTimesWhenSendFailed = 2;
    private int retryTimesWhenSendAsyncFailed = 2;
    private boolean retryAnotherBrokerWhenNotStoreOK = false;
    private int maxMessageSize = 0x400000;
    private int randomSign = RandomUtils.nextInt(0, Integer.MAX_VALUE);
    private boolean addExtendUniqInfo = false;
    private boolean useDefaultTopicIfNotFound = true;
    private TraceDispatcher traceDispatcher = null;

    public DefaultMQProducer() {
        this(null, "DEFAULT_PRODUCER", null);
    }

    public DefaultMQProducer(RPCHook rpcHook) {
        this(null, "DEFAULT_PRODUCER", rpcHook);
    }

    public DefaultMQProducer(String producerGroup) {
        this(null, producerGroup, null);
    }

    public DefaultMQProducer(String producerGroup, RPCHook rpcHook, boolean enableMsgTrace, String customizedTraceTopic) {
        this.producerGroup = producerGroup;
        this.defaultMQProducerImpl = new DefaultMQProducerImpl(this, rpcHook);
        if (enableMsgTrace) {
            try {
                AsyncTraceDispatcher dispatcher = new AsyncTraceDispatcher(producerGroup, TraceDispatcher.Type.PRODUCE, customizedTraceTopic, rpcHook);
                dispatcher.setHostProducer(this.defaultMQProducerImpl);
                this.traceDispatcher = dispatcher;
                this.defaultMQProducerImpl.registerSendMessageHook(new SendMessageTraceHookImpl(this.traceDispatcher));
            }
            catch (Throwable e) {
                this.log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
            }
        }
    }

    public DefaultMQProducer(String namespace, String producerGroup) {
        this(namespace, producerGroup, null);
    }

    public DefaultMQProducer(String producerGroup, RPCHook rpcHook) {
        this(null, producerGroup, rpcHook);
    }

    public DefaultMQProducer(String namespace, String producerGroup, RPCHook rpcHook) {
        this.namespace = namespace;
        this.producerGroup = producerGroup;
        this.defaultMQProducerImpl = new DefaultMQProducerImpl(this, rpcHook);
    }

    public DefaultMQProducer(String producerGroup, boolean enableMsgTrace) {
        this(null, producerGroup, null, enableMsgTrace, null);
    }

    public DefaultMQProducer(String producerGroup, boolean enableMsgTrace, String customizedTraceTopic) {
        this(null, producerGroup, null, enableMsgTrace, customizedTraceTopic);
    }

    public DefaultMQProducer(String namespace, String producerGroup, RPCHook rpcHook, boolean enableMsgTrace, String customizedTraceTopic) {
        this.namespace = namespace;
        this.producerGroup = producerGroup;
        this.defaultMQProducerImpl = new DefaultMQProducerImpl(this, rpcHook);
        if (enableMsgTrace) {
            try {
                AsyncTraceDispatcher dispatcher = new AsyncTraceDispatcher(producerGroup, TraceDispatcher.Type.PRODUCE, customizedTraceTopic, rpcHook);
                dispatcher.setHostProducer(this.getDefaultMQProducerImpl());
                this.traceDispatcher = dispatcher;
                this.getDefaultMQProducerImpl().registerSendMessageHook(new SendMessageTraceHookImpl(this.traceDispatcher));
            }
            catch (Throwable e) {
                this.log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
            }
        }
    }

    @Override
    public void start() throws MQClientException {
        this.setProducerGroup(this.withNamespace(this.producerGroup));
        this.defaultMQProducerImpl.start();
        if (null != this.traceDispatcher) {
            try {
                this.traceDispatcher.start(this.getNamesrvAddr(), this.getAccessChannel());
            }
            catch (MQClientException e) {
                this.log.warn("trace dispatcher start failed ", e);
            }
        }
    }

    @Override
    public void shutdown() {
        this.defaultMQProducerImpl.shutdown();
        if (null != this.traceDispatcher) {
            this.traceDispatcher.shutdown();
        }
    }

    @Override
    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        return this.defaultMQProducerImpl.fetchPublishMessageQueues(this.withNamespace(topic));
    }

    @Override
    public SendResult send(Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        Validators.checkMessage(msg, this);
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg);
    }

    @Override
    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, timeout);
    }

    @Override
    public void send(Message msg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, sendCallback);
    }

    @Override
    public void send(Message msg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, sendCallback, timeout);
    }

    @Override
    public void sendOneway(Message msg) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.sendOneway(msg);
    }

    @Override
    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, this.queueWithNamespace(mq));
    }

    @Override
    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, this.queueWithNamespace(mq), timeout);
    }

    @Override
    public void send(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, this.queueWithNamespace(mq), sendCallback);
    }

    @Override
    public void send(Message msg, MessageQueue mq, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, this.queueWithNamespace(mq), sendCallback, timeout);
    }

    @Override
    public void sendOneway(Message msg, MessageQueue mq) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.sendOneway(msg, this.queueWithNamespace(mq));
    }

    @Override
    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, selector, arg);
    }

    @Override
    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, selector, arg, timeout);
    }

    @Override
    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, selector, arg, sendCallback);
    }

    @Override
    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, selector, arg, sendCallback, timeout);
    }

    @Override
    public Message request(Message msg, long timeout) throws RequestTimeoutException, MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.request(msg, timeout);
    }

    @Override
    public void request(Message msg, RequestCallback requestCallback, long timeout) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.request(msg, requestCallback, timeout);
    }

    @Override
    public Message request(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.request(msg, selector, arg, timeout);
    }

    @Override
    public void request(Message msg, MessageQueueSelector selector, Object arg, RequestCallback requestCallback, long timeout) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.request(msg, selector, arg, requestCallback, timeout);
    }

    @Override
    public Message request(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.request(msg, mq, timeout);
    }

    @Override
    public void request(Message msg, MessageQueue mq, RequestCallback requestCallback, long timeout) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.request(msg, mq, requestCallback, timeout);
    }

    @Override
    public void sendOneway(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.sendOneway(msg, selector, arg);
    }

    @Override
    public TransactionSendResult sendMessageInTransaction(Message msg, LocalTransactionExecuter tranExecuter, Object arg) throws MQClientException {
        throw new RuntimeException("sendMessageInTransaction not implement, please use TransactionMQProducer class");
    }

    @Override
    public TransactionSendResult sendMessageInTransaction(Message msg, Object arg) throws MQClientException {
        throw new RuntimeException("sendMessageInTransaction not implement, please use TransactionMQProducer class");
    }

    @Override
    @Deprecated
    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, this.withNamespace(newTopic), queueNum, 0);
    }

    @Override
    @Deprecated
    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.defaultMQProducerImpl.createTopic(key, this.withNamespace(newTopic), queueNum, topicSysFlag);
    }

    @Override
    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.defaultMQProducerImpl.searchOffset(this.queueWithNamespace(mq), timestamp);
    }

    @Override
    @Deprecated
    public long maxOffset(MessageQueue mq) throws MQClientException {
        return this.defaultMQProducerImpl.maxOffset(this.queueWithNamespace(mq));
    }

    @Override
    @Deprecated
    public long minOffset(MessageQueue mq) throws MQClientException {
        return this.defaultMQProducerImpl.minOffset(this.queueWithNamespace(mq));
    }

    @Override
    @Deprecated
    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        return this.defaultMQProducerImpl.earliestMsgStoreTime(this.queueWithNamespace(mq));
    }

    @Override
    @Deprecated
    public MessageExt viewMessage(String offsetMsgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.defaultMQProducerImpl.viewMessage(offsetMsgId);
    }

    @Override
    @Deprecated
    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.defaultMQProducerImpl.queryMessage(this.withNamespace(topic), key, maxNum, begin, end);
    }

    @Override
    @Deprecated
    public MessageExt viewMessage(String topic, String msgId) throws InterruptedException, MQClientException {
        try {
            MessageId oldMsgId = MessageDecoder.decodeMessageId(msgId);
            return this.viewMessage(msgId);
        }
        catch (Exception exception) {
            return this.defaultMQProducerImpl.queryMessageByUniqKey(this.withNamespace(topic), msgId);
        }
    }

    @Override
    public SendResult send(Collection<Message> msgs) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send(this.batch(msgs));
    }

    @Override
    public SendResult send(Collection<Message> msgs, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs), timeout);
    }

    @Override
    public void send(Collection<Message> msgs, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.defaultMQProducerImpl.send((Message)this.batch(msgs), sendCallback, timeout);
    }

    @Override
    public SendResult send(Collection<Message> msgs, MessageQueue messageQueue) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs), messageQueue);
    }

    @Override
    public SendResult send(Collection<Message> msgs, MessageQueue messageQueue, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs), messageQueue, timeout);
    }

    @Override
    public void send(Collection<Message> msgs, MessageQueue mq, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.defaultMQProducerImpl.send((Message)this.batch(msgs), mq, sendCallback, timeout);
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.defaultMQProducerImpl.setCallbackExecutor(callbackExecutor);
    }

    public void setAsyncSenderExecutor(ExecutorService asyncSenderExecutor) {
        this.defaultMQProducerImpl.setAsyncSenderExecutor(asyncSenderExecutor);
    }

    private MessageBatch batch(Collection<Message> msgs) throws MQClientException {
        MessageBatch msgBatch;
        try {
            msgBatch = MessageBatch.generateFromList(msgs);
            for (Message message : msgBatch) {
                Validators.checkMessage(message, this);
                MessageClientIDSetter.setUniqID(message);
                if (this.isAddExtendUniqInfo()) {
                    MessageClientIDSetter.setExtendUniqInfo(message, this.getRandomSign());
                }
                message.setTopic(this.withNamespace(message.getTopic()));
            }
            msgBatch.setBody(msgBatch.encode());
        }
        catch (Exception e) {
            throw new MQClientException("Failed to initiate the MessageBatch", e);
        }
        msgBatch.setTopic(this.withNamespace(msgBatch.getTopic()));
        return msgBatch;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getCreateTopicKey() {
        return this.createTopicKey;
    }

    public void setCreateTopicKey(String createTopicKey) {
        this.createTopicKey = createTopicKey;
    }

    public int getSendMsgTimeout() {
        return this.sendMsgTimeout;
    }

    public void setSendMsgTimeout(int sendMsgTimeout) {
        this.sendMsgTimeout = sendMsgTimeout;
    }

    public int getCompressMsgBodyOverHowmuch() {
        return this.compressMsgBodyOverHowmuch;
    }

    public void setCompressMsgBodyOverHowmuch(int compressMsgBodyOverHowmuch) {
        this.compressMsgBodyOverHowmuch = compressMsgBodyOverHowmuch;
    }

    @Deprecated
    public DefaultMQProducerImpl getDefaultMQProducerImpl() {
        return this.defaultMQProducerImpl;
    }

    public boolean isRetryAnotherBrokerWhenNotStoreOK() {
        return this.retryAnotherBrokerWhenNotStoreOK;
    }

    public void setRetryAnotherBrokerWhenNotStoreOK(boolean retryAnotherBrokerWhenNotStoreOK) {
        this.retryAnotherBrokerWhenNotStoreOK = retryAnotherBrokerWhenNotStoreOK;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getRandomSign() {
        return this.randomSign;
    }

    public void setRandomSign(int randomSign) {
        this.randomSign = randomSign;
    }

    public boolean isAddExtendUniqInfo() {
        return this.addExtendUniqInfo;
    }

    public void setAddExtendUniqInfo(boolean addExtendUniqInfo) {
        this.addExtendUniqInfo = addExtendUniqInfo;
    }

    public int getDefaultTopicQueueNums() {
        return this.defaultTopicQueueNums;
    }

    public void setDefaultTopicQueueNums(int defaultTopicQueueNums) {
        this.defaultTopicQueueNums = defaultTopicQueueNums;
    }

    public int getRetryTimesWhenSendFailed() {
        return this.retryTimesWhenSendFailed;
    }

    public void setRetryTimesWhenSendFailed(int retryTimesWhenSendFailed) {
        this.retryTimesWhenSendFailed = retryTimesWhenSendFailed;
    }

    public boolean isSendMessageWithVIPChannel() {
        return this.isVipChannelEnabled();
    }

    public void setSendMessageWithVIPChannel(boolean sendMessageWithVIPChannel) {
        this.setVipChannelEnabled(sendMessageWithVIPChannel);
    }

    public long[] getNotAvailableDuration() {
        return this.defaultMQProducerImpl.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.defaultMQProducerImpl.setNotAvailableDuration(notAvailableDuration);
    }

    public long[] getLatencyMax() {
        return this.defaultMQProducerImpl.getLatencyMax();
    }

    public void setLatencyMax(long[] latencyMax) {
        this.defaultMQProducerImpl.setLatencyMax(latencyMax);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.defaultMQProducerImpl.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.defaultMQProducerImpl.setSendLatencyFaultEnable(sendLatencyFaultEnable);
    }

    public int getRetryTimesWhenSendAsyncFailed() {
        return this.retryTimesWhenSendAsyncFailed;
    }

    public void setRetryTimesWhenSendAsyncFailed(int retryTimesWhenSendAsyncFailed) {
        this.retryTimesWhenSendAsyncFailed = retryTimesWhenSendAsyncFailed;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.defaultMQProducerImpl.getEventLoopGroup();
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) throws MQClientException {
        if (this.defaultMQProducerImpl.getServiceState() != ServiceState.CREATE_JUST) {
            throw new MQClientException("The producer service state not OK", null);
        }
        this.defaultMQProducerImpl.setEventLoopGroup(eventLoopGroup);
    }

    public EventExecutorGroup getEventExecutorGroup() {
        return this.defaultMQProducerImpl.getEventExecutorGroup();
    }

    public void setEventExecutorGroup(EventExecutorGroup eventExecutorGroup) throws MQClientException {
        if (this.defaultMQProducerImpl.getServiceState() != ServiceState.CREATE_JUST) {
            throw new MQClientException("The producer service state not OK", null);
        }
        this.defaultMQProducerImpl.setEventExecutorGroup(eventExecutorGroup);
    }

    public boolean isUseDefaultTopicIfNotFound() {
        return this.useDefaultTopicIfNotFound;
    }

    public void setUseDefaultTopicIfNotFound(boolean useDefaultTopicIfNotFound) {
        this.useDefaultTopicIfNotFound = useDefaultTopicIfNotFound;
    }

    public TraceDispatcher getTraceDispatcher() {
        return this.traceDispatcher;
    }
}

