/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace;

import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.AccessChannel;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.common.ThreadLocalIndex;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQClientException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.log.ClientLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.DefaultMQProducer;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.MessageQueueSelector;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendCallback;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendResult;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceDataEncoder;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceDispatcher;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceTransferBean;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.ThreadFactoryImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.UtilAll;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.Message;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.RPCHook;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncTraceDispatcher
implements TraceDispatcher {
    private static final InternalLogger log = ClientLogger.getLog();
    private final int queueSize;
    private final int batchSize;
    private final int maxMsgSize;
    private final DefaultMQProducer traceProducer;
    private final ThreadPoolExecutor traceExecutor;
    private AtomicLong discardCount;
    private Thread worker;
    private ArrayBlockingQueue<TraceContext> traceContextQueue;
    private ArrayBlockingQueue<Runnable> appenderQueue;
    private volatile Thread shutDownHook;
    private volatile boolean stopped = false;
    private DefaultMQProducerImpl hostProducer;
    private DefaultMQPushConsumerImpl hostConsumer;
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private String dispatcherId = UUID.randomUUID().toString();
    private String traceTopicName;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AccessChannel accessChannel = AccessChannel.LOCAL;
    private String group;
    private TraceDispatcher.Type type;

    public AsyncTraceDispatcher(String group, TraceDispatcher.Type type, String traceTopicName, RPCHook rpcHook) {
        this.queueSize = 2048;
        this.batchSize = 100;
        this.maxMsgSize = 128000;
        this.discardCount = new AtomicLong(0L);
        this.traceContextQueue = new ArrayBlockingQueue(1024);
        this.group = group;
        this.type = type;
        this.appenderQueue = new ArrayBlockingQueue(this.queueSize);
        this.traceTopicName = !UtilAll.isBlank(traceTopicName) ? traceTopicName : "RMQ_SYS_TRACE_TOPIC";
        this.traceExecutor = new ThreadPoolExecutor(10, 20, 60000L, TimeUnit.MILLISECONDS, this.appenderQueue, new ThreadFactoryImpl("MQTraceSendThread_"));
        this.traceProducer = this.getAndCreateTraceProducer(rpcHook);
    }

    public AccessChannel getAccessChannel() {
        return this.accessChannel;
    }

    public void setAccessChannel(AccessChannel accessChannel) {
        this.accessChannel = accessChannel;
    }

    public String getTraceTopicName() {
        return this.traceTopicName;
    }

    public void setTraceTopicName(String traceTopicName) {
        this.traceTopicName = traceTopicName;
    }

    public DefaultMQProducer getTraceProducer() {
        return this.traceProducer;
    }

    public DefaultMQProducerImpl getHostProducer() {
        return this.hostProducer;
    }

    public void setHostProducer(DefaultMQProducerImpl hostProducer) {
        this.hostProducer = hostProducer;
    }

    public DefaultMQPushConsumerImpl getHostConsumer() {
        return this.hostConsumer;
    }

    public void setHostConsumer(DefaultMQPushConsumerImpl hostConsumer) {
        this.hostConsumer = hostConsumer;
    }

    @Override
    public void start(String nameSrvAddr, AccessChannel accessChannel) throws MQClientException {
        if (this.isStarted.compareAndSet(false, true)) {
            this.traceProducer.setNamesrvAddr(nameSrvAddr);
            this.traceProducer.setInstanceName("PID_CLIENT_INNER_TRACE_PRODUCER_" + nameSrvAddr);
            this.traceProducer.start();
        }
        this.accessChannel = accessChannel;
        this.worker = new Thread((Runnable)new AsyncRunnable(), "MQ-AsyncTraceDispatcher-Thread-" + this.dispatcherId);
        this.worker.setDaemon(true);
        this.worker.start();
        this.registerShutDownHook();
    }

    private DefaultMQProducer getAndCreateTraceProducer(RPCHook rpcHook) {
        DefaultMQProducer traceProducerInstance = this.traceProducer;
        if (traceProducerInstance == null) {
            traceProducerInstance = new DefaultMQProducer(rpcHook);
            traceProducerInstance.setProducerGroup(this.genGroupNameForTrace());
            traceProducerInstance.setSendMsgTimeout(5000);
            traceProducerInstance.setVipChannelEnabled(false);
            traceProducerInstance.setMaxMessageSize(this.maxMsgSize - 10000);
        }
        return traceProducerInstance;
    }

    private String genGroupNameForTrace() {
        return "_INNER_TRACE_PRODUCER-" + this.group + "-" + (Object)((Object)this.type);
    }

    @Override
    public boolean append(Object ctx) {
        boolean result = this.traceContextQueue.offer((TraceContext)ctx);
        if (!result) {
            log.info("buffer full" + this.discardCount.incrementAndGet() + " ,context is " + ctx);
        }
        return result;
    }

    @Override
    public void flush() throws IOException {
        long end = System.currentTimeMillis() + 500L;
        while (this.traceContextQueue.size() > 0 || this.appenderQueue.size() > 0 && System.currentTimeMillis() <= end) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        log.info("------end trace send " + this.traceContextQueue.size() + "   " + this.appenderQueue.size());
    }

    @Override
    public void shutdown() {
        this.stopped = true;
        this.traceExecutor.shutdown();
        if (this.isStarted.get()) {
            this.traceProducer.shutdown();
        }
        this.removeShutdownHook();
    }

    public void registerShutDownHook() {
        if (this.shutDownHook == null) {
            this.shutDownHook = new Thread(new Runnable(){
                private volatile boolean hasShutdown = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.hasShutdown) {
                            try {
                                AsyncTraceDispatcher.this.flush();
                            }
                            catch (IOException e) {
                                log.error("system MQTrace hook shutdown failed ,maybe loss some trace data");
                            }
                        }
                    }
                }
            }, "ShutdownHookMQTrace");
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
    }

    public void removeShutdownHook() {
        if (this.shutDownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    class AsyncAppenderRequest
    implements Runnable {
        List<TraceContext> contextList;

        public AsyncAppenderRequest(List<TraceContext> contextList) {
            this.contextList = contextList != null ? contextList : new ArrayList<TraceContext>(1);
        }

        @Override
        public void run() {
            this.sendTraceData(this.contextList);
        }

        public void sendTraceData(List<TraceContext> contextList) {
            HashMap transBeanMap = new HashMap();
            for (TraceContext traceContext : contextList) {
                ArrayList<TraceTransferBean> transBeanList;
                if (traceContext.getTraceBeans().isEmpty()) continue;
                String topic = traceContext.getTraceBeans().get(0).getTopic();
                String regionId = traceContext.getRegionId();
                String key = topic;
                if (!StringUtils.isBlank(regionId)) {
                    key = key + '\u0001' + regionId;
                }
                if ((transBeanList = (ArrayList<TraceTransferBean>)transBeanMap.get(key)) == null) {
                    transBeanList = new ArrayList<TraceTransferBean>();
                    transBeanMap.put(key, transBeanList);
                }
                TraceTransferBean traceData = TraceDataEncoder.encoderFromContextBean(traceContext);
                transBeanList.add(traceData);
            }
            for (Map.Entry entry : transBeanMap.entrySet()) {
                String[] key = ((String)entry.getKey()).split(String.valueOf('\u0001'));
                String dataTopic = (String)entry.getKey();
                String regionId = null;
                if (key.length > 1) {
                    dataTopic = key[0];
                    regionId = key[1];
                }
                this.flushData((List)entry.getValue(), dataTopic, regionId);
            }
        }

        private void flushData(List<TraceTransferBean> transBeanList, String dataTopic, String regionId) {
            if (transBeanList.size() == 0) {
                return;
            }
            StringBuilder buffer = new StringBuilder(1024);
            int count = 0;
            HashSet<String> keySet = new HashSet<String>();
            for (TraceTransferBean bean : transBeanList) {
                keySet.addAll(bean.getTransKey());
                buffer.append(bean.getTransData());
                ++count;
                if (buffer.length() < AsyncTraceDispatcher.this.traceProducer.getMaxMessageSize()) continue;
                this.sendTraceDataByMQ(keySet, buffer.toString(), dataTopic, regionId);
                buffer.delete(0, buffer.length());
                keySet.clear();
                count = 0;
            }
            if (count > 0) {
                this.sendTraceDataByMQ(keySet, buffer.toString(), dataTopic, regionId);
            }
            transBeanList.clear();
        }

        private void sendTraceDataByMQ(Set<String> keySet, final String data, String dataTopic, String regionId) {
            String traceTopic = AsyncTraceDispatcher.this.traceTopicName;
            if (AccessChannel.CLOUD == AsyncTraceDispatcher.this.accessChannel) {
                traceTopic = "rmq_sys_TRACE_DATA_" + regionId;
            }
            Message message = new Message(traceTopic, data.getBytes());
            message.setKeys(keySet);
            try {
                Set<String> traceBrokerSet = this.tryGetMessageQueueBrokerSet(AsyncTraceDispatcher.this.traceProducer.getDefaultMQProducerImpl(), traceTopic);
                SendCallback callback = new SendCallback(){

                    @Override
                    public void onSuccess(SendResult sendResult) {
                    }

                    @Override
                    public void onException(Throwable e) {
                        log.info("send trace data ,the traceData is " + data);
                    }
                };
                if (traceBrokerSet.isEmpty()) {
                    AsyncTraceDispatcher.this.traceProducer.send(message, callback, 5000L);
                } else {
                    AsyncTraceDispatcher.this.traceProducer.send(message, new MessageQueueSelector(){

                        @Override
                        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                            Set brokerSet = (Set)arg;
                            ArrayList<MessageQueue> filterMqs = new ArrayList<MessageQueue>();
                            for (MessageQueue queue : mqs) {
                                if (!brokerSet.contains(queue.getBrokerName())) continue;
                                filterMqs.add(queue);
                            }
                            int index = AsyncTraceDispatcher.this.sendWhichQueue.getAndIncrement();
                            int pos = Math.abs(index) % filterMqs.size();
                            if (pos < 0) {
                                pos = 0;
                            }
                            return (MessageQueue)filterMqs.get(pos);
                        }
                    }, traceBrokerSet, callback);
                }
            }
            catch (Exception e) {
                log.info("send trace data,the traceData is" + data);
            }
        }

        private Set<String> tryGetMessageQueueBrokerSet(DefaultMQProducerImpl producer, String topic) {
            HashSet<String> brokerSet = new HashSet<String>();
            TopicPublishInfo topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(topic);
            if (null == topicPublishInfo || !topicPublishInfo.ok()) {
                producer.getTopicPublishInfoTable().putIfAbsent(topic, new TopicPublishInfo());
                producer.getmQClientFactory().updateTopicRouteInfoFromNameServer(topic);
                topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(topic);
            }
            if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
                for (MessageQueue queue : topicPublishInfo.getMessageQueueList()) {
                    brokerSet.add(queue.getBrokerName());
                }
            }
            return brokerSet;
        }
    }

    class AsyncRunnable
    implements Runnable {
        private boolean stopped;

        AsyncRunnable() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                ArrayList<TraceContext> contexts = new ArrayList<TraceContext>(AsyncTraceDispatcher.this.batchSize);
                for (int i = 0; i < AsyncTraceDispatcher.this.batchSize; ++i) {
                    TraceContext context = null;
                    try {
                        context = (TraceContext)AsyncTraceDispatcher.this.traceContextQueue.poll(5L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (context == null) break;
                    contexts.add(context);
                }
                if (contexts.size() > 0) {
                    AsyncAppenderRequest request = new AsyncAppenderRequest(contexts);
                    AsyncTraceDispatcher.this.traceExecutor.submit(request);
                    continue;
                }
                if (!AsyncTraceDispatcher.this.stopped) continue;
                this.stopped = true;
            }
        }
    }
}

