/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.hook;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeReturnType;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageHook;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceBean;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceDispatcher;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.trace.TraceType;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.NamespaceUtil;
import java.util.ArrayList;

public class ConsumeMessageTraceHookImpl
implements ConsumeMessageHook {
    private TraceDispatcher localDispatcher;

    public ConsumeMessageTraceHookImpl(TraceDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    @Override
    public String hookName() {
        return "ConsumeMessageTraceHook";
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        TraceContext traceContext = new TraceContext();
        context.setMqTraceContext(traceContext);
        traceContext.setTraceType(TraceType.SubBefore);
        traceContext.setGroupName(NamespaceUtil.withoutNamespace(context.getConsumerGroup()));
        ArrayList<TraceBean> beans = new ArrayList<TraceBean>();
        for (MessageExt msg : context.getMsgList()) {
            if (msg == null) continue;
            String regionId = msg.getProperty("MSG_REGION");
            String traceOn = msg.getProperty("TRACE_ON");
            if (traceOn != null && traceOn.equals("false")) continue;
            TraceBean traceBean = new TraceBean();
            traceBean.setTopic(NamespaceUtil.withoutNamespace(msg.getTopic()));
            traceBean.setMsgId(msg.getMsgId());
            traceBean.setTags(msg.getTags());
            traceBean.setKeys(msg.getKeys());
            traceBean.setStoreTime(msg.getStoreTimestamp());
            traceBean.setBodyLength(msg.getStoreSize());
            traceBean.setRetryTimes(msg.getReconsumeTimes());
            traceContext.setRegionId(regionId);
            beans.add(traceBean);
        }
        if (beans.size() > 0) {
            traceContext.setTraceBeans(beans);
            traceContext.setTimeStamp(System.currentTimeMillis());
            this.localDispatcher.append(traceContext);
        }
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        TraceContext subBeforeContext = (TraceContext)context.getMqTraceContext();
        if (subBeforeContext.getTraceBeans() == null || subBeforeContext.getTraceBeans().size() < 1) {
            return;
        }
        TraceContext subAfterContext = new TraceContext();
        subAfterContext.setTraceType(TraceType.SubAfter);
        subAfterContext.setRegionId(subBeforeContext.getRegionId());
        subAfterContext.setGroupName(NamespaceUtil.withoutNamespace(subBeforeContext.getGroupName()));
        subAfterContext.setRequestId(subBeforeContext.getRequestId());
        subAfterContext.setSuccess(context.isSuccess());
        int costTime = (int)((System.currentTimeMillis() - subBeforeContext.getTimeStamp()) / (long)context.getMsgList().size());
        subAfterContext.setCostTime(costTime);
        subAfterContext.setTraceBeans(subBeforeContext.getTraceBeans());
        String contextType = context.getProps().get("ConsumeContextType");
        if (contextType != null) {
            subAfterContext.setContextCode(ConsumeReturnType.valueOf(contextType).ordinal());
        }
        this.localDispatcher.append(subAfterContext);
    }
}

