/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.body;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.DataVersion;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.TopicConfig;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLoggerFactory;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.protocol.RemotingSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class RegisterBrokerBody
extends RemotingSerializable {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqCommon");
    private TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
    private List<String> filterServerList = new ArrayList<String>();

    public byte[] encode(boolean compress) {
        if (!compress) {
            return super.encode();
        }
        long start = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream outputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9));
        DataVersion dataVersion = this.topicConfigSerializeWrapper.getDataVersion();
        ConcurrentMap<String, TopicConfig> topicConfigTable = RegisterBrokerBody.cloneTopicConfigTable(this.topicConfigSerializeWrapper.getTopicConfigTable());
        assert (topicConfigTable != null);
        try {
            byte[] buffer = dataVersion.encode();
            outputStream.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
            outputStream.write(buffer);
            int topicNumber = topicConfigTable.size();
            outputStream.write(RegisterBrokerBody.convertIntToByteArray(topicNumber));
            for (Map.Entry next : topicConfigTable.entrySet()) {
                buffer = ((TopicConfig)next.getValue()).encode().getBytes("UTF-8");
                outputStream.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
                outputStream.write(buffer);
            }
            buffer = JSON.toJSONString(this.filterServerList).getBytes("UTF-8");
            outputStream.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
            outputStream.write(buffer);
            outputStream.finish();
            long interval = System.currentTimeMillis() - start;
            if (interval > 50L) {
                LOGGER.info("Compressing takes {}ms", (Object)interval);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Failed to compress RegisterBrokerBody object", e);
            return null;
        }
    }

    public static RegisterBrokerBody decode(byte[] data, boolean compressed) throws IOException {
        if (!compressed) {
            return RegisterBrokerBody.decode(data, RegisterBrokerBody.class);
        }
        long start = System.currentTimeMillis();
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(data));
        int dataVersionLength = RegisterBrokerBody.readInt(inflaterInputStream);
        byte[] dataVersionBytes = RegisterBrokerBody.readBytes(inflaterInputStream, dataVersionLength);
        DataVersion dataVersion = DataVersion.decode(dataVersionBytes, DataVersion.class);
        RegisterBrokerBody registerBrokerBody = new RegisterBrokerBody();
        registerBrokerBody.getTopicConfigSerializeWrapper().setDataVersion(dataVersion);
        ConcurrentMap<String, TopicConfig> topicConfigTable = registerBrokerBody.getTopicConfigSerializeWrapper().getTopicConfigTable();
        int topicConfigNumber = RegisterBrokerBody.readInt(inflaterInputStream);
        LOGGER.debug("{} topic configs to extract", (Object)topicConfigNumber);
        for (int i = 0; i < topicConfigNumber; ++i) {
            int topicConfigJsonLength = RegisterBrokerBody.readInt(inflaterInputStream);
            byte[] buffer = RegisterBrokerBody.readBytes(inflaterInputStream, topicConfigJsonLength);
            TopicConfig topicConfig = new TopicConfig();
            String topicConfigJson = new String(buffer, "UTF-8");
            topicConfig.decode(topicConfigJson);
            topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        }
        int filterServerListJsonLength = RegisterBrokerBody.readInt(inflaterInputStream);
        byte[] filterServerListBuffer = RegisterBrokerBody.readBytes(inflaterInputStream, filterServerListJsonLength);
        String filterServerListJson = new String(filterServerListBuffer, "UTF-8");
        ArrayList<String> filterServerList = new ArrayList();
        try {
            filterServerList = JSON.parseArray(filterServerListJson, String.class);
        }
        catch (Exception e) {
            LOGGER.error("Decompressing occur Exception {}", (Object)filterServerListJson);
        }
        registerBrokerBody.setFilterServerList(filterServerList);
        long interval = System.currentTimeMillis() - start;
        if (interval > 50L) {
            LOGGER.info("Decompressing takes {}ms", (Object)interval);
        }
        return registerBrokerBody;
    }

    private static byte[] convertIntToByteArray(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        return byteBuffer.array();
    }

    private static byte[] readBytes(InflaterInputStream inflaterInputStream, int length) throws IOException {
        int len;
        byte[] buffer = new byte[length];
        for (int bytesRead = 0; bytesRead < length; bytesRead += len) {
            len = inflaterInputStream.read(buffer, bytesRead, length - bytesRead);
            if (len != -1) continue;
            throw new IOException("End of compressed data has reached");
        }
        return buffer;
    }

    private static int readInt(InflaterInputStream inflaterInputStream) throws IOException {
        byte[] buffer = RegisterBrokerBody.readBytes(inflaterInputStream, 4);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        return byteBuffer.getInt();
    }

    public TopicConfigSerializeWrapper getTopicConfigSerializeWrapper() {
        return this.topicConfigSerializeWrapper;
    }

    public void setTopicConfigSerializeWrapper(TopicConfigSerializeWrapper topicConfigSerializeWrapper) {
        this.topicConfigSerializeWrapper = topicConfigSerializeWrapper;
    }

    public List<String> getFilterServerList() {
        return this.filterServerList;
    }

    public void setFilterServerList(List<String> filterServerList) {
        this.filterServerList = filterServerList;
    }

    public static ConcurrentMap<String, TopicConfig> cloneTopicConfigTable(ConcurrentMap<String, TopicConfig> topicConfigConcurrentMap) {
        ConcurrentHashMap<String, TopicConfig> result = new ConcurrentHashMap<String, TopicConfig>();
        if (topicConfigConcurrentMap != null) {
            for (Map.Entry entry : topicConfigConcurrentMap.entrySet()) {
                result.put((String)entry.getKey(), (TopicConfig)entry.getValue());
            }
        }
        return result;
    }
}

