/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.queue;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.queue.RoundQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLoggerFactory;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentTreeMap<K, V> {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqBroker");
    private final ReentrantLock lock;
    private TreeMap<K, V> tree;
    private RoundQueue<K> roundQueue;

    public ConcurrentTreeMap(int capacity, Comparator<? super K> comparator) {
        this.tree = new TreeMap(comparator);
        this.roundQueue = new RoundQueue(capacity);
        this.lock = new ReentrantLock(true);
    }

    public Map.Entry<K, V> pollFirstEntry() {
        this.lock.lock();
        try {
            Map.Entry<K, V> entry = this.tree.pollFirstEntry();
            return entry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsentAndRetExsit(K key, V value) {
        this.lock.lock();
        try {
            V exsit;
            if (this.roundQueue.put(key)) {
                V exsit2 = this.tree.get(key);
                if (null == exsit2) {
                    this.tree.put(key, value);
                    exsit2 = value;
                }
                log.warn("putIfAbsentAndRetExsit success. " + key);
                V v = exsit2;
                return v;
            }
            V v = exsit = this.tree.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

