/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.utils;

import com.alipay.sofa.sofamq.com.shade.google.common.hash.Hashing;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MessageUtils {
    public static int getShardingKeyIndex(String shardingKey, int indexSize) {
        return Math.abs(Hashing.murmur3_32().hashBytes(shardingKey.getBytes()).asInt() % indexSize);
    }

    public static Set<Integer> getShardingKeyIndexes(Collection<MessageExt> msgs, int indexSize) {
        HashSet<Integer> indexSet = new HashSet<Integer>(indexSize);
        for (MessageExt msg : msgs) {
            String shardingKey = msg.getProperty("__SHARDINGKEY");
            if (shardingKey == null) {
                shardingKey = "";
            }
            int index = MessageUtils.getShardingKeyIndex(shardingKey, indexSize);
            indexSet.add(index);
        }
        return indexSet;
    }
}

