/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.filter.util;

import com.alipay.sofa.sofamq.com.shade.google.common.hash.Hashing;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.filter.util.BitsArray;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.filter.util.BloomFilterData;
import java.nio.charset.Charset;

public class BloomFilter {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private int f = 10;
    private int n = 128;
    private int k;
    private int m;

    public static BloomFilter createByFn(int f, int n) {
        return new BloomFilter(f, n);
    }

    private BloomFilter(int f, int n) {
        if (f < 1 || f >= 100) {
            throw new IllegalArgumentException("f must be greater or equal than 1 and less than 100");
        }
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.f = f;
        this.n = n;
        double errorRate = (double)f / 100.0;
        this.k = (int)Math.ceil(this.logMN(0.5, errorRate));
        if (this.k < 1) {
            throw new IllegalArgumentException("Hash function num is less than 1, maybe you should change the value of error rate or bit num!");
        }
        this.m = (int)Math.ceil((double)this.n * this.logMN(2.0, 1.0 / errorRate) * this.logMN(2.0, Math.E));
        this.m = (int)(8.0 * Math.ceil((double)this.m / 8.0));
    }

    public int[] calcBitPositions(String str) {
        int[] bitPositions = new int[this.k];
        long hash64 = Hashing.murmur3_128().hashString(str, UTF_8).asLong();
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.k; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            bitPositions[i - 1] = combinedHash % this.m;
        }
        return bitPositions;
    }

    public BloomFilterData generate(String str) {
        int[] bitPositions = this.calcBitPositions(str);
        return new BloomFilterData(bitPositions, this.m);
    }

    public void hashTo(String str, BitsArray bits) {
        this.hashTo(this.calcBitPositions(str), bits);
    }

    public void hashTo(int[] bitPositions, BitsArray bits) {
        this.check(bits);
        for (int i : bitPositions) {
            bits.setBit(i, true);
        }
    }

    public void hashTo(BloomFilterData filterData, BitsArray bits) {
        if (!this.isValid(filterData)) {
            throw new IllegalArgumentException(String.format("Bloom filter data may not belong to this filter! %s, %s", filterData, this.toString()));
        }
        this.hashTo(filterData.getBitPos(), bits);
    }

    public boolean isHit(String str, BitsArray bits) {
        return this.isHit(this.calcBitPositions(str), bits);
    }

    public boolean isHit(int[] bitPositions, BitsArray bits) {
        this.check(bits);
        boolean ret = bits.getBit(bitPositions[0]);
        for (int i = 1; i < bitPositions.length; ++i) {
            ret &= bits.getBit(bitPositions[i]);
        }
        return ret;
    }

    public boolean isHit(BloomFilterData filterData, BitsArray bits) {
        if (!this.isValid(filterData)) {
            throw new IllegalArgumentException(String.format("Bloom filter data may not belong to this filter! %s, %s", filterData, this.toString()));
        }
        return this.isHit(filterData.getBitPos(), bits);
    }

    public boolean checkFalseHit(int[] bitPositions, BitsArray bits) {
        for (int j = 0; j < bitPositions.length; ++j) {
            int pos = bitPositions[j];
            if (bits.getBit(pos)) continue;
            return false;
        }
        return true;
    }

    protected void check(BitsArray bits) {
        if (bits.bitLength() != this.m) {
            throw new IllegalArgumentException(String.format("Length(%d) of bits in BitsArray is not equal to %d!", bits.bitLength(), this.m));
        }
    }

    public boolean isValid(BloomFilterData filterData) {
        return filterData != null && filterData.getBitNum() == this.m && filterData.getBitPos() != null && filterData.getBitPos().length == this.k;
    }

    public int getF() {
        return this.f;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public int getM() {
        return this.m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BloomFilter)) {
            return false;
        }
        BloomFilter that = (BloomFilter)o;
        if (this.f != that.f) {
            return false;
        }
        if (this.k != that.k) {
            return false;
        }
        if (this.m != that.m) {
            return false;
        }
        return this.n == that.n;
    }

    public int hashCode() {
        int result = this.f;
        result = 31 * result + this.n;
        result = 31 * result + this.k;
        result = 31 * result + this.m;
        return result;
    }

    public String toString() {
        return String.format("f: %d, n: %d, k: %d, m: %d", this.f, this.n, this.k, this.m);
    }

    protected double logMN(double m, double n) {
        return Math.log(n) / Math.log(m);
    }
}

