/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.stats;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.RemotingUtil;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.stats.StatsItem;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.stats.StatsSnapshot;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StatsItemSet {
    private final ConcurrentMap<String, StatsItem> statsItemTable = new ConcurrentHashMap<String, StatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public StatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, InternalLogger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInSeconds();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 1L, TimeUnit.HOURS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(RemotingUtil.computeNextMinutesTimeMillis() - System.currentTimeMillis()), 60000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(RemotingUtil.computeNextHourTimeMillis() - System.currentTimeMillis()), 3600000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtDay();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(RemotingUtil.computeNextMorningTimeMillis() - System.currentTimeMillis()), 86400000L, TimeUnit.MILLISECONDS);
    }

    private void samplingInSeconds() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).samplingInSeconds();
        }
    }

    private void samplingInMinutes() {
        Iterator it = this.statsItemTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            StatsItem statsItem = (StatsItem)next.getValue();
            statsItem.samplingInMinutes();
            LinkedList<StatsItem.CallSnapshot> csList = statsItem.getCsListHour();
            if (csList == null || csList.size() < 7) continue;
            StatsItem.CallSnapshot first = csList.getFirst();
            StatsItem.CallSnapshot last = csList.getLast();
            if (first.getTimes() != last.getTimes() || first.getValue() != last.getValue()) continue;
            it.remove();
        }
    }

    private void samplingInHour() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).samplingInHour();
        }
    }

    private void printAtMinutes() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).printAtMinutes();
        }
    }

    private void printAtHour() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).printAtHour();
        }
    }

    private void printAtDay() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).printAtDay();
        }
    }

    public void addValue(String statsKey, int incValue, int incTimes) {
        StatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().addAndGet(incValue);
        statsItem.getTimes().addAndGet(incTimes);
    }

    public StatsItem getAndCreateStatsItem(String statsKey) {
        StatsItem prev;
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null == statsItem && null != (prev = this.statsItemTable.putIfAbsent(statsKey, statsItem = new StatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            statsItem = prev;
        }
        return statsItem;
    }

    public StatsSnapshot getStatsDataInMinute(String statsKey) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getStatsDataInMinute();
        }
        return new StatsSnapshot();
    }

    public StatsSnapshot getStatsDataInHour(String statsKey) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getStatsDataInHour();
        }
        return new StatsSnapshot();
    }

    public StatsSnapshot getStatsDataInDay(String statsKey) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getStatsDataInDay();
        }
        return new StatsSnapshot();
    }

    public StatsItem getStatsItem(String statsKey) {
        return (StatsItem)this.statsItemTable.get(statsKey);
    }

    public ConcurrentMap<String, StatsItem> getStatsItemTable() {
        return this.statsItemTable;
    }
}

