/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.netty;

import com.alipay.sofa.sofamq.io.shade.netty.channel.DefaultMessageSizeEstimator;
import com.alipay.sofa.sofamq.io.shade.netty.channel.MessageSizeEstimator;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.protocol.RemotingCommand;

public class MqDefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new MqDefaultMessageSizeEstimator(100);
    private final MessageSizeEstimator.Handle handle;

    @Override
    public MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    public MqDefaultMessageSizeEstimator(int unknownSize) {
        if (unknownSize < 0) {
            throw new IllegalArgumentException("unknownSize: " + unknownSize + " (expected: >= 0)");
        }
        this.handle = new HandleImpl(unknownSize);
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int unknownSize) {
            this.unknownSize = unknownSize;
        }

        @Override
        public int size(Object msg) {
            if (msg instanceof RemotingCommand) {
                byte[] body = ((RemotingCommand)msg).getBody();
                if (body == null) {
                    return this.unknownSize;
                }
                return body.length;
            }
            return DefaultMessageSizeEstimator.DEFAULT.newHandle().size(msg);
        }
    }
}

