/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.netty;

import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBuf;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelHandlerContext;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLoggerFactory;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.RemotingHelper;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.RemotingUtil;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.protocol.RemotingCommand;
import java.nio.ByteBuffer;

public class NettyDecoder
extends LengthFieldBasedFrameDecoder {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final int FRAME_MAX_LENGTH = Integer.parseInt(System.getProperty("com.rocketmq.remoting.frameMaxLength", "16777216"));

    public NettyDecoder() {
        super(FRAME_MAX_LENGTH, 0, 4, 0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = null;
        try {
            frame = (ByteBuf)super.decode(ctx, in);
            if (null == frame) {
                Object var4_4 = null;
                return var4_4;
            }
            ByteBuffer byteBuffer = frame.nioBuffer();
            RemotingCommand remotingCommand = RemotingCommand.decode(byteBuffer);
            return remotingCommand;
        }
        catch (Exception e) {
            log.error("decode exception, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel()), e);
            RemotingUtil.closeChannel(ctx.channel());
        }
        finally {
            if (null != frame) {
                frame.release();
            }
        }
        return null;
    }
}

