/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.netty;

import com.alipay.sofa.sofamq.io.shade.netty.buffer.ByteBuf;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelHandler;
import com.alipay.sofa.sofamq.io.shade.netty.channel.ChannelHandlerContext;
import com.alipay.sofa.sofamq.io.shade.netty.handler.codec.MessageToByteEncoder;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLoggerFactory;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.RemotingHelper;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.RemotingUtil;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.protocol.RemotingCommand;
import java.nio.ByteBuffer;

@ChannelHandler.Sharable
public class NettyEncoder
extends MessageToByteEncoder<RemotingCommand> {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");

    @Override
    public void encode(ChannelHandlerContext ctx, RemotingCommand remotingCommand, ByteBuf out) throws Exception {
        try {
            ByteBuffer header = remotingCommand.encodeHeader();
            out.writeBytes(header);
            byte[] body = remotingCommand.getBody();
            if (body != null) {
                out.writeBytes(body);
            }
        }
        catch (Exception e) {
            log.error("encode exception, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel()), e);
            if (remotingCommand != null) {
                log.error(remotingCommand.toString());
            }
            RemotingUtil.closeChannel(ctx.channel());
        }
    }
}

