/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.netty;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLoggerFactory;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.common.stats.StatsItemSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class RemotingStatsService {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqStats");
    private static final String REQ_WAITING_MICROS = "REQ_WAITING_MICROS";
    private static final String REQ_PROCESS_MICROS = "REQ_PROCESS_MICROS";
    private final Map<String, StatsItemSet> statsTable = new HashMap<String, StatsItemSet>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "RemotingStatsThread");
        }
    });

    public RemotingStatsService() {
        this.statsTable.put(REQ_WAITING_MICROS, new StatsItemSet(REQ_WAITING_MICROS, this.scheduledExecutorService, log));
        this.statsTable.put(REQ_PROCESS_MICROS, new StatsItemSet(REQ_PROCESS_MICROS, this.scheduledExecutorService, log));
    }

    public void incReqWaitingMicros(int requestCode, long waitingMicros) {
        this.statsTable.get(REQ_WAITING_MICROS).addValue(Integer.toString(requestCode), (int)waitingMicros, 1);
    }

    public void incReqProcessMicros(int requestCode, long processMicros) {
        this.statsTable.get(REQ_PROCESS_MICROS).addValue(Integer.toString(requestCode), (int)processMicros, 1);
    }
}

