/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.netty;

import com.alipay.sofa.sofamq.io.shade.netty.channel.Channel;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.protocol.RemotingCommand;

public class RequestTask
implements Runnable {
    private final Runnable runnable;
    private final long createTimestamp = System.currentTimeMillis();
    private final Channel channel;
    private final RemotingCommand request;
    private boolean stopRun = false;

    public RequestTask(Runnable runnable, Channel channel, RemotingCommand request) {
        this.runnable = runnable;
        this.channel = channel;
        this.request = request;
    }

    public int hashCode() {
        int result = this.runnable != null ? this.runnable.hashCode() : 0;
        result = 31 * result + (int)(this.getCreateTimestamp() ^ this.getCreateTimestamp() >>> 32);
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + (this.request != null ? this.request.hashCode() : 0);
        result = 31 * result + (this.isStopRun() ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestTask)) {
            return false;
        }
        RequestTask that = (RequestTask)o;
        if (this.getCreateTimestamp() != that.getCreateTimestamp()) {
            return false;
        }
        if (this.isStopRun() != that.isStopRun()) {
            return false;
        }
        if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) {
            return false;
        }
        return this.request != null ? this.request.getOpaque() == that.request.getOpaque() : that.request == null;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public boolean isStopRun() {
        return this.stopRun;
    }

    public void setStopRun(boolean stopRun) {
        this.stopRun = stopRun;
    }

    @Override
    public void run() {
        if (!this.stopRun) {
            this.runnable.run();
        }
    }

    public void returnResponse(int code, String remark) {
        RemotingCommand response = RemotingCommand.createResponseCommand(code, remark);
        response.setOpaque(this.request.getOpaque());
        this.channel.writeAndFlush(response);
    }
}

