/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.spring;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.springframework.context.Lifecycle;

public abstract class AbstractComponent
implements Lifecycle {
    private static final AtomicReferenceFieldUpdater<AbstractComponent, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractComponent.class, State.class, "state");
    private volatile State state = State.CREATED;

    protected abstract void start0();

    protected abstract void stop0();

    public void start() {
        if (stateUpdater.compareAndSet(this, State.CREATED, State.RUNNING)) {
            this.start0();
        }
    }

    public void stop() {
        if (stateUpdater.compareAndSet(this, State.RUNNING, State.TERMINATED)) {
            this.stop0();
        }
    }

    public boolean isRunning() {
        return this.state.isRunning();
    }

    static enum State {
        CREATED,
        RUNNING,
        TERMINATED;


        public boolean isRunning() {
            return this == RUNNING;
        }
    }
}

