/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.spring;

import com.alipay.sofa.sofamq.api.Consumer;
import com.alipay.sofa.sofamq.api.MessageConsumer;
import com.alipay.sofa.sofamq.api.MessageProducer;
import com.alipay.sofa.sofamq.api.Messaging;
import com.alipay.sofa.sofamq.api.OrderConsumer;
import com.alipay.sofa.sofamq.api.Producer;
import com.alipay.sofa.sofamq.api.TransactionChecker;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.spring.AsyncMessageProcessor;
import com.alipay.sofa.sofamq.spring.ConsumerImpl;
import com.alipay.sofa.sofamq.spring.ConsumerManager;
import com.alipay.sofa.sofamq.spring.MessageProcessor;
import com.alipay.sofa.sofamq.spring.OrderConsumerImpl;
import com.alipay.sofa.sofamq.spring.ProducerManager;
import com.alipay.sofa.sofamq.spring.SiteConsumerImpl;
import com.alipay.sofa.sofamq.spring.TransactionCheckProcessor;
import io.openmessaging.api.Action;
import io.openmessaging.api.Admin;
import io.openmessaging.api.AsyncConsumeContext;
import io.openmessaging.api.GenericMessage;
import io.openmessaging.api.MessageConsumeContext;
import io.openmessaging.api.transaction.TransactionStatus;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.ReflectionUtils;

public class BeanParser {
    private static final InternalLogger log = ClientLoggerUtil.getClientLogger();
    private ProducerManager producerManager;
    private ConsumerManager consumerManager;
    private Set<Class<?>> processedClass;

    public BeanParser(ProducerManager producerManager, ConsumerManager consumerManager) {
        this.producerManager = producerManager;
        this.consumerManager = consumerManager;
        this.processedClass = new HashSet();
    }

    public Object parse(Object bean) {
        if (!this.filter(bean)) {
            return bean;
        }
        this.parseMessageProducer(bean);
        this.parseTransactionChecker(bean);
        this.parserMessageConsumer(bean);
        return bean;
    }

    private boolean filter(Object bean) {
        Class<?> beanClass = bean.getClass();
        Messaging messaging = beanClass.getAnnotation(Messaging.class);
        return messaging != null;
    }

    private void parseMessageProducer(final Object bean) {
        final Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at static field %s is not allowed", MessageProducer.class.getName(), field.getName()));
                }
                if (!Modifier.isPublic(field.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at non-public field(%s) is not allowed", MessageProducer.class.getName(), field.getName()));
                }
                Class<?> producerClass = field.getType();
                if (producerClass != Producer.class) {
                    throw new IllegalArgumentException(String.format("field(%s)'s type should be %s", field.getName(), Producer.class.getName()));
                }
                MessageProducer messageProducer = field.getAnnotation(MessageProducer.class);
                if (messageProducer.payload() == null || messageProducer.payload().length != 1) {
                    throw new IllegalArgumentException(String.format("MessageProducer[%s] payload[%s] is illegal", messageProducer.group(), messageProducer.payload()));
                }
                log.info("scan MessageProducer {} from {}#{}", messageProducer, beanClass.getCanonicalName(), field.getName());
                Producer producer = BeanParser.this.producerManager.getProducer(messageProducer);
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, (Object)producer);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return field.isAnnotationPresent(MessageProducer.class);
            }
        });
    }

    private void parseTransactionChecker(final Object bean) {
        final Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(final Method method) throws IllegalArgumentException, IllegalAccessException {
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at static method(%s) is not allowed", TransactionChecker.class.getName(), method.getName()));
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at non-public method(%s) is not allowed", TransactionChecker.class.getName(), method.getName()));
                }
                TransactionChecker transactionChecker = method.getAnnotation(TransactionChecker.class);
                if (method.getParameterTypes().length != 1 || !GenericMessage.class.equals(method.getParameterTypes()[0]) || !TransactionStatus.class.equals(method.getReturnType())) {
                    throw new IllegalArgumentException(String.format("@%s annotated  method(%s) is not match signature: TransactionStatus methodName(GenericMessage)", TransactionChecker.class.getName(), method.getName()));
                }
                log.info("scan TransactionChecker {} from {}#{}", transactionChecker, beanClass.getCanonicalName(), method.getName());
                BeanParser.this.producerManager.registerTransactionChecker(transactionChecker, new TransactionCheckProcessor(){

                    public TransactionStatus check(GenericMessage msg) {
                        try {
                            return (TransactionStatus)((Object)method.invoke(bean, msg));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e.getCause());
                        }
                    }
                });
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.isAnnotationPresent(TransactionChecker.class);
            }
        });
    }

    private void parserMessageConsumer(final Object bean) {
        final Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                boolean siteConsumer;
                MessageConsumer messageConsumer;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at static field %s is not allowed", MessageConsumer.class.getName(), field.getName()));
                }
                if (!Modifier.isPublic(field.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at non-public field(%s) is not allowed", MessageConsumer.class.getName(), field.getName()));
                }
                Class<?> consumerClass = field.getType();
                if (consumerClass != Consumer.class && consumerClass != OrderConsumer.class) {
                    throw new IllegalArgumentException(String.format("field(%s)'s type should be %s or %s", field.getName(), Consumer.class.getName(), OrderConsumer.class.getName()));
                }
                boolean orderly = consumerClass == OrderConsumer.class;
                if (orderly != (messageConsumer = field.getAnnotation(MessageConsumer.class)).orderly()) {
                    throw new IllegalArgumentException(String.format("field(%s)'s type %s not match @MessageConsumer(orderly=%s)", field.getName(), beanClass.getName(), messageConsumer.orderly()));
                }
                log.info("scan MessageConsumer {} from {}#{}", messageConsumer, beanClass.getCanonicalName(), field.getName());
                Admin consumer = BeanParser.this.consumerManager.getMessageConsumer(messageConsumer);
                ReflectionUtils.makeAccessible((Field)field);
                boolean bl = siteConsumer = StringUtils.isNotBlank(messageConsumer.messageModel()) && StringUtils.equals(messageConsumer.messageModel(), "SITE_BROADCASTING");
                if (orderly) {
                    ReflectionUtils.setField((Field)field, (Object)bean, (Object)new OrderConsumerImpl((io.openmessaging.api.order.OrderConsumer)consumer));
                } else if (siteConsumer) {
                    ReflectionUtils.setField((Field)field, (Object)bean, (Object)new SiteConsumerImpl((io.openmessaging.api.Consumer)consumer));
                } else {
                    ReflectionUtils.setField((Field)field, (Object)bean, (Object)new ConsumerImpl((io.openmessaging.api.Consumer)consumer));
                }
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return field.isAnnotationPresent(MessageConsumer.class);
            }
        });
        if (!this.processedClass.add(beanClass)) {
            return;
        }
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(final Method method) throws IllegalArgumentException {
                boolean async;
                Class<?> payload;
                boolean pojo;
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at static method(%s) is not allowed", MessageConsumer.class.getName(), method.getName()));
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException(String.format("@%s annotated at non-public method(%s) is not allowed", MessageConsumer.class.getName(), method.getName()));
                }
                final MessageConsumer messageConsumer = method.getAnnotation(MessageConsumer.class);
                int paramLength = method.getParameterTypes().length;
                if (method.getParameterTypes().length != 1 && paramLength != 2) {
                    throw new IllegalArgumentException(String.format("@%s annotated method parameters don't match (GenericMessage<POJO>) or (POJO)", MessageConsumer.class.getName()));
                }
                Class<?>[] parameterTypes = method.getParameterTypes();
                boolean bl = pojo = !parameterTypes[0].equals(GenericMessage.class);
                if (pojo) {
                    payload = parameterTypes[0];
                } else {
                    if (messageConsumer.payload().length != 1) {
                        throw new IllegalArgumentException(String.format("MessageConsumer[%s] [%s] payload[%s] is illegal", messageConsumer.group(), messageConsumer.topic(), messageConsumer.payload()));
                    }
                    payload = messageConsumer.payload()[0];
                }
                log.info("scan MessageConsumer {} from {}#{}", messageConsumer, beanClass.getCanonicalName(), method.getName());
                boolean bl2 = async = paramLength == 2 && parameterTypes[1] != null && parameterTypes[1].equals(AsyncConsumeContext.class);
                if (!async) {
                    BeanParser.this.consumerManager.registerMessageProcessor(messageConsumer, payload, new MessageProcessor(){

                        @Override
                        public boolean process(GenericMessage message, MessageConsumeContext context) {
                            try {
                                if (pojo) {
                                    method.invoke(bean, message.getValue());
                                } else {
                                    method.invoke(bean, message);
                                }
                            }
                            catch (IllegalAccessException e) {
                                log.warn("consumeMessage exception Group: {} Msgs: {}", messageConsumer.group(), message, e);
                                return false;
                            }
                            catch (InvocationTargetException e) {
                                log.warn("consumeMessage exception Group: {} Msgs: {}", messageConsumer.group(), message, e.getCause());
                                return false;
                            }
                            return true;
                        }
                    });
                } else {
                    BeanParser.this.consumerManager.registerAsyncMessageProcessor(messageConsumer, payload, new AsyncMessageProcessor(){

                        public void process(GenericMessage message, AsyncConsumeContext context) {
                            try {
                                if (pojo) {
                                    method.invoke(bean, message.getValue(), context);
                                } else {
                                    method.invoke(bean, message, context);
                                }
                            }
                            catch (IllegalAccessException e) {
                                log.warn("consumeMessage exception Group: {} Msgs: {}", messageConsumer.group(), message, e);
                                context.commit(Action.ReconsumeLater);
                            }
                            catch (InvocationTargetException e) {
                                log.warn("consumeMessage exception Group: {} Msgs: {}", messageConsumer.group(), message, e.getCause());
                                context.commit(Action.ReconsumeLater);
                            }
                        }
                    });
                }
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.isAnnotationPresent(MessageConsumer.class);
            }
        });
    }
}

