/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.spring;

import com.alipay.sofa.sofamq.api.Producer;
import com.alipay.sofa.sofamq.spring.SofaMQProducer;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageBuilder;
import io.openmessaging.api.OMSResponseStatus;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import io.openmessaging.api.TransactionalResult;
import io.openmessaging.api.exception.OMSMessageFormatException;
import java.util.concurrent.ExecutorService;

public class ProducerImpl<T>
implements Producer<T> {
    private SofaMQProducer producer;
    private String topic;
    private Class<?> payloadClass;

    public ProducerImpl(SofaMQProducer producer, String topic, Class<?> payload) {
        this.producer = producer;
        this.topic = topic;
        this.payloadClass = payload;
        producer.validateWriteSchema(topic, payload);
    }

    @Override
    public SendResult send(Message message) {
        this.checkMessageWithSchema(message);
        return this.producer.send(message);
    }

    @Override
    public void sendOneway(Message message) {
        this.checkMessageWithSchema(message);
        this.producer.sendOneway(message);
    }

    @Override
    public void sendAsync(Message message, SendCallback sendCallback) {
        this.checkMessageWithSchema(message);
        this.producer.sendAsync(message, sendCallback);
    }

    @Override
    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.producer.setCallbackExecutor(callbackExecutor);
    }

    @Override
    public SendResult send(Message message, String shardingKey) {
        this.checkMessageWithSchema(message);
        return this.producer.send(message, shardingKey);
    }

    @Override
    public TransactionalResult prepare(Message message) {
        this.checkMessageWithSchema(message);
        return this.producer.prepare(message);
    }

    @Override
    public MessageBuilder<T> messageBuilder() {
        return this.producer.messageBuilder().withTopic(this.topic);
    }

    public void checkMessageWithSchema(Message message) {
        if (byte[].class.equals(this.payloadClass)) {
            return;
        }
        String schemaId = message.getSystemProperties("__SCHEMA.ID");
        if (schemaId == null) {
            throw new OMSMessageFormatException(OMSResponseStatus.STATUS_1418.getStatusCode(), "[MESSAGE_SCHEMA_MISSING]");
        }
    }
}

