/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.spring;

import com.alipay.sofa.runtime.api.component.LazyActivateBean;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.spring.BeanParser;
import com.alipay.sofa.sofamq.spring.ConsumerManager;
import com.alipay.sofa.sofamq.spring.ProducerManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class SofaMQBeanProcessor
implements BeanPostProcessor,
LazyActivateBean,
ApplicationListener<ContextClosedEvent> {
    private static final InternalLogger log = ClientLoggerUtil.getClientLogger();
    private static final String NOOP = "noop";
    private static final String EMPTY_STRING = "";
    private BeanParser beanParser;
    private ProducerManager producerManager;
    private ConsumerManager consumerManager;

    public SofaMQBeanProcessor(String endpoint, String schemaRegistryUrl) {
        if (schemaRegistryUrl == null || NOOP.equals(schemaRegistryUrl.trim().toLowerCase())) {
            schemaRegistryUrl = EMPTY_STRING;
        }
        this.producerManager = new ProducerManager(endpoint, schemaRegistryUrl);
        this.consumerManager = new ConsumerManager(endpoint, schemaRegistryUrl);
        this.beanParser = new BeanParser(this.producerManager, this.consumerManager);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.beanParser.parse(bean);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void activate() {
        if (!this.consumerManager.isRunning()) {
            this.consumerManager.start();
            log.info("start sofamq consumer manager");
        }
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.consumerManager.stop();
        this.producerManager.stop();
    }
}

