/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.sofamq;

import com.alipay.sofa.sofamq.client.BatchConsumerImpl;
import com.alipay.sofa.sofamq.client.ConsumerImpl;
import com.alipay.sofa.sofamq.client.OrderConsumerImpl;
import com.alipay.sofa.sofamq.client.OrderProducerImpl;
import com.alipay.sofa.sofamq.client.ProducerImpl;
import com.alipay.sofa.sofamq.client.PullConsumerImpl;
import com.alipay.sofa.sofamq.client.SiteConsumerImpl;
import com.alipay.sofa.sofamq.client.TransactionProducerImpl;
import com.alipay.sofa.sofamq.client.elastic.ElasticBatchConsumerImpl;
import com.alipay.sofa.sofamq.client.elastic.ElasticConsumerImpl;
import com.alipay.sofa.sofamq.client.elastic.ElasticOrderConsumerImpl;
import io.openmessaging.api.Consumer;
import io.openmessaging.api.MessagingAccessPoint;
import io.openmessaging.api.Producer;
import io.openmessaging.api.PullConsumer;
import io.openmessaging.api.batch.BatchConsumer;
import io.openmessaging.api.order.OrderConsumer;
import io.openmessaging.api.order.OrderProducer;
import io.openmessaging.api.transaction.LocalTransactionChecker;
import io.openmessaging.api.transaction.TransactionProducer;
import java.util.Map;
import java.util.Properties;

public class MessagingAccessPointImpl
implements MessagingAccessPoint {
    private Properties attributes;

    public MessagingAccessPointImpl(Properties attributes) {
        this.attributes = attributes;
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    public Properties attributes() {
        return this.attributes;
    }

    @Override
    public Producer createProducer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        return new ProducerImpl(all);
    }

    @Override
    public OrderProducer createOrderProducer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        return new OrderProducerImpl(all);
    }

    @Override
    public TransactionProducer createTransactionProducer(Properties properties, LocalTransactionChecker checker) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        return new TransactionProducerImpl(all, checker);
    }

    @Override
    public TransactionProducer createTransactionProducer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        return new TransactionProducerImpl(all);
    }

    @Override
    public Consumer createConsumer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        if (this.isElastic(properties)) {
            return new ConsumerImpl(all);
        }
        if (this.isSiteBroadcasting(all)) {
            all.setProperty("messageModel", "BROADCASTING");
            return new SiteConsumerImpl(all);
        }
        return new ElasticConsumerImpl(all);
    }

    @Override
    public PullConsumer createPullConsumer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        return new PullConsumerImpl(all);
    }

    @Override
    public BatchConsumer createBatchConsumer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        if (this.isElastic(properties)) {
            return new BatchConsumerImpl(all);
        }
        return new ElasticBatchConsumerImpl(all);
    }

    @Override
    public OrderConsumer createOrderedConsumer(Properties properties) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)this.attributes);
        all.putAll((Map<?, ?>)properties);
        if (this.isElastic(properties)) {
            return new OrderConsumerImpl(all);
        }
        return new ElasticOrderConsumerImpl(all);
    }

    private boolean isElastic(Properties props) {
        return "true".equals(props.getProperty("elastic"));
    }

    private boolean isSiteBroadcasting(Properties properties) {
        String messageModel = properties.getProperty("messageModel");
        if (messageModel == null) {
            return false;
        }
        return messageModel.equals("SITE_BROADCASTING");
    }
}

