/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springcloud.init;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.common.utils.PortUtils;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

public class ContextRegisterListener
implements ApplicationListener<ContextRefreshedEvent>,
BeanFactoryAware {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRegisterListener.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final Boolean isFull;
    private final String host;
    private final String contextPath;
    private final String appName;
    private final Integer port;
    private BeanFactory beanFactory;

    public ContextRegisterListener(PropertiesConfig config, Environment env) {
        Properties props = config.getProps();
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.contextPath = Optional.ofNullable(props.getProperty("contextPath")).map(UriUtils::repairData).orElse(null);
        if (Boolean.TRUE.equals(this.isFull) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "http register param must config the contextPath";
            LOG.error(errorMsg);
            throw new ShenyuClientIllegalArgumentException(errorMsg);
        }
        this.port = Integer.parseInt(Optional.ofNullable(props.getProperty("port")).orElseGet(() -> "-1"));
        this.appName = env.getProperty("spring.application.name");
        this.host = props.getProperty("host");
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent webServerInitializedEvent) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        if (Boolean.TRUE.equals(this.isFull)) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO());
        }
        int mergedPort = this.port <= 0 ? PortUtils.findPort((BeanFactory)this.beanFactory) : this.port;
        this.publisher.publishEvent((DataTypeParent)this.buildUriRegisterDTO(mergedPort));
    }

    private URIRegisterDTO buildUriRegisterDTO(int port) {
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).host(IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host)).port(Integer.valueOf(port)).rpcType(RpcTypeEnum.SPRING_CLOUD.getName()).build();
    }

    private MetaDataRegisterDTO buildMetaDataDTO() {
        return MetaDataRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).path(PathUtils.decoratorPath((String)this.contextPath)).rpcType(RpcTypeEnum.SPRING_CLOUD.getName()).enabled(true).ruleName(this.contextPath).build();
    }
}

