/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springcloud.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.springcloud.annotation.ShenyuSpringCloudClient;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringCloudClientEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(SpringCloudClientEventListener.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final Boolean isFull;
    private final Environment env;
    private final String servletContextPath;
    private final List<Class<? extends Annotation>> mappingAnnotation = new ArrayList<Class<? extends Annotation>>(7);
    private final String[] pathAttributeNames = new String[]{"path", "value"};

    public SpringCloudClientEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository, Environment env) {
        String appName = env.getProperty("spring.application.name");
        Properties props = clientConfig.getProps();
        this.contextPath = Optional.ofNullable(props.getProperty("contextPath")).map(UriUtils::repairData).orElse(null);
        if (StringUtils.isBlank((CharSequence)appName)) {
            String errorMsg = "spring cloud param must config the appName";
            LOG.error(errorMsg);
            throw new ShenyuClientIllegalArgumentException(errorMsg);
        }
        this.env = env;
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.servletContextPath = env.getProperty("server.servlet.context-path", "");
        this.mappingAnnotation.add(ShenyuSpringCloudClient.class);
        this.mappingAnnotation.add(RequestMapping.class);
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        Map beans = contextRefreshedEvent.getApplicationContext().getBeansWithAnnotation(Controller.class);
        for (Map.Entry entry : beans.entrySet()) {
            this.handler(entry.getValue());
        }
    }

    private void handler(Object bean) {
        Method[] methods;
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        if (Boolean.TRUE.equals(this.isFull)) {
            return;
        }
        ShenyuSpringCloudClient beanShenyuClient = (ShenyuSpringCloudClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuSpringCloudClient.class);
        String superPath = this.buildApiSuperPath(clazz, beanShenyuClient);
        if (Objects.nonNull(beanShenyuClient) && superPath.contains("*")) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(beanShenyuClient, this.pathJoin(this.contextPath, superPath)));
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz)) {
            RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
            ShenyuSpringCloudClient methodShenyuClient = (ShenyuSpringCloudClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSpringCloudClient.class);
            ShenyuSpringCloudClient shenyuSpringCloudClient = methodShenyuClient = Objects.isNull(methodShenyuClient) ? beanShenyuClient : methodShenyuClient;
            if (!Objects.nonNull(methodShenyuClient) || !Objects.nonNull(requestMapping)) continue;
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(methodShenyuClient, this.buildApiPath(method, superPath, methodShenyuClient)));
        }
    }

    private <A extends Annotation> boolean hasAnnotation(@NonNull Class<?> clazz, @NonNull Class<A> annotationType) {
        return Objects.nonNull(AnnotationUtils.findAnnotation(clazz, annotationType));
    }

    private String buildApiPath(@NonNull Method method, @NonNull String superPath, ShenyuSpringCloudClient methodShenyuClient) {
        if (Objects.nonNull(methodShenyuClient) && StringUtils.isNotBlank((CharSequence)methodShenyuClient.path())) {
            return this.pathJoin(this.contextPath, superPath, methodShenyuClient.path());
        }
        String path = this.getPathByMethod(method);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.pathJoin(this.contextPath, superPath, path);
        }
        return this.pathJoin(this.contextPath, superPath);
    }

    private String getPathByMethod(@NonNull Method method) {
        for (Class<? extends Annotation> mapping : this.mappingAnnotation) {
            Annotation mergedAnnotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, mapping);
            String pathByAnnotation = this.getPathByAnnotation(mergedAnnotation, this.pathAttributeNames);
            if (!StringUtils.isNotBlank((CharSequence)pathByAnnotation)) continue;
            return pathByAnnotation;
        }
        return null;
    }

    private String getPathByAnnotation(@Nullable Annotation annotation, String ... pathAttributeName) {
        if (Objects.isNull(annotation)) {
            return null;
        }
        for (String s : pathAttributeName) {
            Object value = AnnotationUtils.getValue((Annotation)annotation, (String)s);
            if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
                return (String)value;
            }
            if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])((String[])value)) || !StringUtils.isNotBlank((CharSequence)((String[])value)[0])) continue;
            return ((String[])value)[0];
        }
        return null;
    }

    private String buildApiSuperPath(@NonNull Class<?> clazz, ShenyuSpringCloudClient beanShenyuClient) {
        if (Objects.nonNull(beanShenyuClient) && StringUtils.isNotBlank((CharSequence)beanShenyuClient.path())) {
            return beanShenyuClient.path();
        }
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
        if (Objects.nonNull(requestMapping) && ArrayUtils.isNotEmpty((Object[])requestMapping.path()) && StringUtils.isNotBlank((CharSequence)requestMapping.path()[0])) {
            return requestMapping.path()[0];
        }
        return "";
    }

    private String pathJoin(String ... path) {
        StringBuilder result = new StringBuilder(PATH_SEPARATOR);
        for (String p : path) {
            if (!result.toString().endsWith(PATH_SEPARATOR)) {
                result.append(PATH_SEPARATOR);
            }
            result.append(p.startsWith(PATH_SEPARATOR) ? p.replaceFirst(PATH_SEPARATOR, "") : p);
        }
        return result.toString();
    }

    private MetaDataRegisterDTO buildMetaDataDTO(ShenyuSpringCloudClient shenyuSpringCloudClient, String path) {
        String appName = this.env.getProperty("spring.application.name");
        String desc = shenyuSpringCloudClient.desc();
        String configRuleName = shenyuSpringCloudClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        return MetaDataRegisterDTO.builder().contextPath((String)StringUtils.defaultIfBlank((CharSequence)this.contextPath, (CharSequence)this.servletContextPath)).appName(appName).path(path).pathDesc(desc).rpcType(RpcTypeEnum.SPRING_CLOUD.getName()).enabled(shenyuSpringCloudClient.enabled()).ruleName(ruleName).build();
    }
}

