/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache;

import java.util.Objects;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.CacheRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cache.ICache;
import org.apache.shenyu.plugin.cache.handler.CachePluginDataHandler;
import org.apache.shenyu.plugin.cache.utils.CacheUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class CachePlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        byte[] bytes;
        ICache cache = CacheUtils.getCache();
        if (Objects.nonNull(cache) && Objects.nonNull(bytes = cache.getData(CacheUtils.dataKey(exchange)))) {
            exchange.getResponse().getHeaders().setContentType(cache.getContentType(CacheUtils.contentTypeKey(exchange)));
            return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(bytes)).doOnNext(data -> exchange.getResponse().getHeaders().setContentLength((long)data.readableByteCount())));
        }
        CacheRuleHandle cacheRuleHandle = (CacheRuleHandle)CachePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        return chain.execute(exchange.mutate().response((ServerHttpResponse)new CacheHttpResponse(exchange, cacheRuleHandle)).build());
    }

    public int getOrder() {
        return PluginEnum.CACHE.getCode();
    }

    public String named() {
        return PluginEnum.CACHE.getName();
    }

    static class CacheHttpResponse
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final CacheRuleHandle cacheRuleHandle;

        CacheHttpResponse(ServerWebExchange exchange, CacheRuleHandle cacheRuleHandle) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.cacheRuleHandle = cacheRuleHandle;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            return super.writeWith(this.cacheResponse(body));
        }

        @NonNull
        private Flux<? extends DataBuffer> cacheResponse(Publisher<? extends DataBuffer> body) {
            ICache cache = CacheUtils.getCache();
            if (Objects.nonNull(cache)) {
                MediaType contentType = this.getHeaders().getContentType();
                return Flux.from(body).doOnNext(buffer -> {
                    cache.cacheData(CacheUtils.dataKey(this.exchange), buffer.asByteBuffer().array(), this.cacheRuleHandle.getTimeoutSeconds().longValue());
                    cache.cacheContentType(CacheUtils.contentTypeKey(this.exchange), contentType, this.cacheRuleHandle.getTimeoutSeconds().longValue());
                });
            }
            return Flux.from(body);
        }
    }
}

