/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache.handler;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.impl.CacheRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cache.ICache;
import org.apache.shenyu.plugin.cache.ICacheBuilder;
import org.apache.shenyu.plugin.cache.config.CacheConfig;
import org.apache.shenyu.plugin.cache.utils.CacheUtils;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachePluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, CacheRuleHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    private static final Logger LOG = LoggerFactory.getLogger(CachePluginDataHandler.class);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.isNull(pluginData) || Boolean.FALSE.equals(pluginData.getEnabled())) {
            LOG.info("the plugin {} is disabled", (Object)this.pluginNamed());
            this.closeCacheIfNeed();
            return;
        }
        String config = pluginData.getConfig();
        CacheConfig cacheConfig = (CacheConfig)GsonUtils.getInstance().fromJson(config, CacheConfig.class);
        if (Objects.isNull(cacheConfig)) {
            LOG.info("invalid cacheConfig.");
            return;
        }
        LOG.info("use the {} cache.", (Object)cacheConfig.getCacheType());
        cacheConfig.setConfig(config);
        CacheConfig lastCacheConfig = (CacheConfig)Singleton.INST.get(CacheConfig.class);
        if (cacheConfig.equals(lastCacheConfig)) {
            LOG.info("cache plugin initialized.");
            return;
        }
        Singleton.INST.single(CacheConfig.class, (Object)cacheConfig);
        this.closeCacheIfNeed();
        ICacheBuilder cacheBuilder = (ICacheBuilder)ExtensionLoader.getExtensionLoader(ICacheBuilder.class).getJoin(cacheConfig.getCacheType());
        Singleton.INST.single(ICache.class, (Object)cacheBuilder.builderCache(config));
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(json -> {
            CacheRuleHandle cacheRuleHandle = (CacheRuleHandle)GsonUtils.getInstance().fromJson(json, CacheRuleHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)cacheRuleHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(json -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.CACHE.getName();
    }

    private void closeCacheIfNeed() {
        ICache lastCache = CacheUtils.getCache();
        if (Objects.nonNull(lastCache)) {
            LOG.info("close the last cache {}", (Object)lastCache);
            lastCache.close();
        }
    }
}

