/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sentinel.handler;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.SentinelHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class SentinelRuleHandle
implements PluginDataHandler {
    public void handlerRule(RuleData ruleData) {
        SentinelHandle sentinelHandle = (SentinelHandle)GsonUtils.getInstance().fromJson(ruleData.getHandle(), SentinelHandle.class);
        sentinelHandle.checkData(sentinelHandle);
        String key = CacheKeyUtils.INST.getKey(ruleData);
        List flowRules = FlowRuleManager.getRules().stream().filter(r -> !r.getResource().equals(key)).collect(Collectors.toList());
        if (sentinelHandle.getFlowRuleEnable() == 1) {
            FlowRule rule = new FlowRule(key);
            rule.setCount((double)sentinelHandle.getFlowRuleCount().intValue());
            rule.setGrade(sentinelHandle.getFlowRuleGrade().intValue());
            rule.setControlBehavior(sentinelHandle.getFlowRuleControlBehavior().intValue());
            flowRules.add(rule);
        }
        FlowRuleManager.loadRules(flowRules);
        List degradeRules = DegradeRuleManager.getRules().stream().filter(r -> !r.getResource().equals(key)).collect(Collectors.toList());
        if (sentinelHandle.getDegradeRuleEnable() == 1) {
            DegradeRule rule = new DegradeRule(key);
            rule.setCount(sentinelHandle.getDegradeRuleCount().doubleValue());
            rule.setGrade(sentinelHandle.getDegradeRuleGrade().intValue());
            rule.setTimeWindow(sentinelHandle.getDegradeRuleTimeWindow().intValue());
            rule.setStatIntervalMs(sentinelHandle.getDegradeRuleStatIntervals() * 1000);
            rule.setMinRequestAmount(sentinelHandle.getDegradeRuleMinRequestAmount().intValue());
            rule.setSlowRatioThreshold(sentinelHandle.getDegradeRuleSlowRatioThreshold().doubleValue());
            degradeRules.add(rule);
        }
        DegradeRuleManager.loadRules(degradeRules);
    }

    public void removeRule(RuleData ruleData) {
        String key = CacheKeyUtils.INST.getKey(ruleData);
        FlowRuleManager.loadRules(FlowRuleManager.getRules().stream().filter(r -> !r.getResource().equals(key)).collect(Collectors.toList()));
        DegradeRuleManager.loadRules(DegradeRuleManager.getRules().stream().filter(r -> !r.getResource().equals(key)).collect(Collectors.toList()));
    }

    public String pluginNamed() {
        return PluginEnum.SENTINEL.getName();
    }
}

