/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.base.fDefaultApplication;
import com.pcbsys.foundation.memory.fMemoryManager;

public abstract class fBaseApplication {
    private static fBaseApplication myApplication = new fDefaultApplication();
    private boolean exitOnDiskSpace = true;
    private boolean exitOnMemorySpace = true;
    private boolean exitOnIOErrors = true;
    private boolean exitOnInterfaceFailure = false;
    private String myName = "Application";
    private int myFileRetryCount = 10;
    private long myFileTimeout = 500L;

    public fBaseApplication(String string) {
        this(string, true, true, true);
    }

    public fBaseApplication(String string, boolean bl, boolean bl2, boolean bl3) {
        this.myName = string;
        this.exitOnDiskSpace = bl;
        this.exitOnMemorySpace = bl2;
        this.exitOnIOErrors = bl3;
        myApplication = this;
        if (this.exitOnMemorySpace) {
            fMemoryManager.getInstance();
        }
    }

    public static fBaseApplication getApplication() {
        return myApplication;
    }

    public static void setApplication(fBaseApplication fBaseApplication2) {
        myApplication = fBaseApplication2;
    }

    public abstract void shutdown(String var1);

    public void diskSpaceError(String string) {
        if (this.exitOnDiskSpace) {
            this.applicationClosure(string);
        } else {
            System.out.println(string);
        }
    }

    public void setExitOnInterfaceFailure(boolean bl) {
        this.exitOnInterfaceFailure = bl;
    }

    public boolean getExitOnInterfaceFailure() {
        return this.exitOnInterfaceFailure;
    }

    public void interfaceError(String string) {
        if (this.exitOnInterfaceFailure) {
            this.applicationClosure(string);
        } else {
            System.out.println(string);
        }
    }

    public void memoryError(String string) {
        if (this.exitOnMemorySpace) {
            this.applicationClosure(string);
        } else {
            System.out.println(string);
        }
    }

    public void fileDescriptorError(String string) {
        if (this.exitOnIOErrors) {
            this.applicationClosure(" fatal environment error : " + string);
        } else {
            System.out.println(string);
        }
    }

    public void fileOperationFailure(String string) {
        if (this.exitOnIOErrors) {
            this.applicationClosure(" fatal file I/O error occurred : " + string);
        } else {
            System.out.println(string);
        }
    }

    public void dataMigrationError(String string) {
        this.applicationClosure(string);
    }

    private void applicationClosure(String string) {
        try {
            System.out.println(this.myName + " shutting down due to " + string);
            this.shutdown(string);
        }
        catch (Throwable throwable) {
            System.exit(1);
        }
    }

    public long getFileTimeout() {
        return this.myFileTimeout;
    }

    public void setFileTimeout(long l) {
        this.myFileTimeout = l;
    }

    public int getFileRetryCount() {
        return this.myFileRetryCount;
    }

    public void setFileRetryCount(int n) {
        this.myFileRetryCount = n;
    }

    public boolean exitOnDiskError() {
        return this.exitOnDiskSpace;
    }

    public void exitOnDiskError(boolean bl) {
        this.exitOnDiskSpace = bl;
    }

    public boolean isExitOnIOErrors() {
        return this.exitOnIOErrors;
    }

    public void setExitOnIOErrors(boolean bl) {
        this.exitOnIOErrors = bl;
    }

    public void reportThreadPoolStall(String string) {
    }
}

