/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.base.fMonitorState;
import com.pcbsys.foundation.base.fMonitorable;
import com.pcbsys.foundation.fConstants;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class fBaseMonitor {
    private final String threadName;
    private final ConcurrentHashMap<fMonitorable, ScheduledFuture<?>> myMap;
    private final ScheduledExecutorService scheduler;

    protected fBaseMonitor(String string) {
        this.threadName = string;
        this.myMap = new ConcurrentHashMap();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, this.threadName);
            thread.setDaemon(true);
            return thread;
        });
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.myMap.clear();
    }

    public int size() {
        return this.myMap.size();
    }

    public synchronized void add(fMonitorable fMonitorable2) {
        MonitorTask monitorTask = new MonitorTask(fMonitorable2);
        long l = monitorTask.getInterval();
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleWithFixedDelay(monitorTask, l, l, TimeUnit.MILLISECONDS);
        this.myMap.put(fMonitorable2, scheduledFuture);
    }

    public synchronized void del(fMonitorable fMonitorable2) {
        ScheduledFuture<?> scheduledFuture = this.myMap.get(fMonitorable2);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.myMap.remove(fMonitorable2);
        }
    }

    public synchronized void reSchedule(fMonitorable fMonitorable2) {
        this.del(fMonitorable2);
        this.add(fMonitorable2);
    }

    public Iterator<fMonitorable> list() {
        return ((ConcurrentHashMap.KeySetView)this.myMap.keySet()).iterator();
    }

    static class MonitorTask
    implements Runnable {
        private final fMonitorable monitor;

        public long getInterval() {
            return this.monitor.monitorInterval();
        }

        MonitorTask(fMonitorable fMonitorable2) {
            this.monitor = fMonitorable2;
        }

        @Override
        public void run() {
            try {
                if (this.monitor.state() != fMonitorState.OK) {
                    this.monitor.rectify();
                }
            }
            catch (Exception exception) {
                fConstants.logger.error(exception);
            }
        }
    }
}

